/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.lcbenchmarks;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import com.sap.sapdb.benchmark.common.Version;
import com.sap.sapdb.benchmark.tp2.common.AccessType;
import com.sap.sapdb.benchmark.tp2.common.Tp2Case;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class LcBenchmarkResultsEnv {
    private Vector locks = null;
    public static final long LOCK_TIMEOUT = 10000L;
    private PreparedStatement listSessionIdsForBench = null;
    private PreparedStatement listSessionsForUserTP = null;
    private PreparedStatement listSessionsForServerNodeTP = null;
    private PreparedStatement listSessionsForDBDescTP = null;
    private PreparedStatement listSessionsForUserWisc = null;
    private PreparedStatement listSessionsForServerNodeWisc = null;
    private PreparedStatement listSessionsForDBDescWisc = null;
    private PreparedStatement listOpenSessions = null;
    private PreparedStatement listUsers = null;
    private PreparedStatement listShortBuilds = null;
    private PreparedStatement listServerNodes = null;
    private PreparedStatement listBenchmarkTypes = null;
    private PreparedStatement listDBDescsForSessionAndServerNodeTP = null;
    private PreparedStatement listAccessTypesForSessionAndServerNode = null;
    private PreparedStatement listAccessTypesForSession = null;
    private PreparedStatement listAccessTypes = null;
    private PreparedStatement listServerNodesForSessionTP = null;
    private PreparedStatement listTp2CasesForSession = null;
    private PreparedStatement moveResultsForServerNode = null;
    private PreparedStatement moveResultsForServerNodeAndDBDesc = null;
    private PreparedStatement insertSessionComment = null;
    private PreparedStatement updateSessionComment = null;
    private PreparedStatement readSessionComment = null;
    private PreparedStatement removeSessionComment = null;
    public static final String DEF_T = "def";
    public static final String SESSION_T = "sess";
    public static final String USER_T = "users";
    public static final String SERVERNODE_T = "nodes";
    public static final String DBDESC_T = "dbdesc";

    public LcBenchmarkResultsEnv() throws Exception {
        BenchEnv.stdOut("LcBenchmarkResultsEnv", "### Created LcBenchmarkResultsEnv ###");
    }

    public void initConnection(String host, String database, String user, String password) throws Exception {
        if (StorableObject.isConnectionOpen()) {
            StorableObject.closeConnection();
        }
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        StorableObject.initConnection("jdbc:sapdb://" + host + "/" + database + "?user=" + user + "&password=" + password + "&cache=all");
        try {
            this.prepareStatements(StorableObject.getConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void prepareStatements(Connection conn) throws SQLException {
        this.locks = new Vector();
        this.listSessionIdsForBench = conn.prepareStatement("SELECT id FROM sessions WHERE benchmark_type=?");
        this.listSessionsForUserTP = conn.prepareStatement("(SELECT id,description,benchmark_type,begin_date,end_date, COUNT(lnk.def_id) AS tests_count FROM sessions sess, tp2_sessions_results lnk WHERE sess.id=lnk.session_id  AND sess.user_id=? AND sess.benchmark_type<>'Wisconsin' GROUP BY id,description,benchmark_type,begin_date,end_date) UNION  (SELECT id,description,benchmark_type,begin_date,end_date,0 AS tests_count FROM sessions sess WHERE sess.user_id=? AND sess.id NOT IN (SELECT session_id FROM tp2_sessions_results) AND sess.benchmark_type<>'Wisconsin' GROUP BY id,description,benchmark_type,begin_date,end_date)");
        this.listSessionsForUserWisc = conn.prepareStatement("(SELECT id,description,benchmark_type,begin_date,end_date, COUNT(lnk.def_id) AS tests_count FROM sessions sess, wisc_sessions_results lnk WHERE sess.id=lnk.session_id AND sess.user_id=? AND sess.benchmark_type='Wisconsin' GROUP BY id,description,benchmark_type,begin_date,end_date) UNION  (SELECT id,description,benchmark_type,begin_date,end_date, COUNT(lnk.def_id) AS tests_count FROM sessions sess, wisc_sessions_results lnk WHERE sess.user_id=? AND sess.id NOT IN (SELECT session_id FROM wisc_sessions_results) AND sess.benchmark_type='Wisconsin' GROUP BY id,description,benchmark_type,begin_date,end_date)");
        this.listSessionsForServerNodeTP = conn.prepareStatement("SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,users.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail, COUNT(lnk.def_id) AS tests_count FROM sessions sess,users, tp2_definitions def, tp2_sessions_results lnk WHERE def.id=lnk.def_id AND sess.user_id=users.id AND sess.id=lnk.session_id AND sess.benchmark_type<>'Wisconsin' AND def.servernode_id=? GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,users.id,users.name,users.description,users.mail");
        this.listSessionsForServerNodeWisc = conn.prepareStatement("SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,users.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail, COUNT(lnk.def_id) AS tests_count FROM sessions sess,users, wisc_definitions def, wisc_sessions_results lnk WHERE def.id=lnk.def_id AND sess.user_id=users.id AND sess.id=lnk.session_id AND sess.benchmark_type='Wisconsin' AND def.servernode_id=? GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,users.id,users.name,users.description,users.mail");
        this.listSessionsForDBDescTP = conn.prepareStatement("SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,users.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail, COUNT(lnk.def_id) AS tests_count FROM sessions sess,users, tp2_definitions def, tp2_sessions_results lnk WHERE def.id=lnk.def_id AND sess.user_id=users.id AND sess.benchmark_type<>'Wisconsin' AND sess.id=lnk.session_id AND def.dbdescription_id=? GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,users.id,users.name,users.description,users.mail");
        this.listSessionsForDBDescWisc = conn.prepareStatement("SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,users.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail, COUNT(lnk.def_id) AS tests_count FROM sessions sess,users, wisc_definitions def, wisc_sessions_results lnk WHERE def.id=lnk.def_id AND sess.user_id=users.id AND sess.benchmark_type='Wisconsin' AND sess.id=lnk.session_id AND def.dbdescription_id=? GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,users.id,users.name,users.description,users.mail");
        this.listOpenSessions = conn.prepareStatement("((SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail,\n COUNT(lnk.def_id) AS tests_count\n FROM sessions sess,users, tp2_sessions_results lnk\n WHERE sess.user_id=users.id\n AND sess.benchmark_type<>'Wisconsin'\n AND sess.id=lnk.session_id\n AND sess.is_closed=FALSE\n GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id,users.name,users.description,users.mail)\n UNION (SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail,\n 0 AS tests_count\n FROM sessions sess,users\n WHERE sess.user_id=users.id\n AND sess.benchmark_type<>'Wisconsin'\n AND sess.id NOT IN (SELECT session_id FROM tp2_sessions_results) AND sess.is_closed=FALSE\n GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id,users.name,users.description,users.mail))\n UNION \n ((SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail,\n COUNT(lnk.def_id) AS tests_count\n FROM sessions sess,users, wisc_sessions_results lnk\n WHERE sess.user_id=users.id\n AND sess.benchmark_type='Wisconsin'\n AND sess.id=lnk.session_id\n AND sess.is_closed=FALSE\n GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id,users.name,users.description,users.mail)\n UNION  (SELECT sess.id AS sess_id,sess.description AS sess_desc,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id AS user_id,users.name AS user_name,users.description AS user_desc,users.mail AS user_mail,\n 0 AS tests_count\n FROM sessions sess,users\n WHERE sess.user_id=users.id\n AND sess.benchmark_type='Wisconsin'\n AND sess.id NOT IN (SELECT session_id FROM wisc_sessions_results) AND sess.is_closed=FALSE\n GROUP BY sess.id ,sess.description,sess.benchmark_type,sess.begin_date,sess.end_date,\nusers.id,users.name,users.description,users.mail))\n");
        this.listUsers = conn.prepareStatement("SELECT id,name,description,mail FROM users");
        this.listShortBuilds = conn.prepareStatement("SELECT DISTINCT major,minor,correction_level,SUBSTR(build,1,3) AS short_build FROM dbdescriptions");
        this.listServerNodes = conn.prepareStatement("SELECT id,host_name,os_name,os_version,memory_mb,processor_count,processor_mhz   FROM servernodes where host_name in (select distinct host from lcbench_headers) ");
        this.listBenchmarkTypes = conn.prepareStatement("SELECT DISTINCT benchmark_type  FROM sessions");
        this.listDBDescsForSessionAndServerNodeTP = conn.prepareStatement("SELECT DISTINCT d.id,d.major,d.minor,d.correction_level,d.build,d.dbparameters_id,d.maxcpu  FROM dbdescriptions d, tp2_sessions_results lnk, tp2_definitions def WHERE def.id=lnk.def_id AND d.id=def.dbdescription_id AND lnk.session_id=? AND def.servernode_id=?");
        this.listAccessTypesForSessionAndServerNode = conn.prepareStatement("SELECT DISTINCT def.user_type  FROM tp2_sessions_results lnk, tp2_definitions def WHERE def.id=lnk.def_id AND def.servernode_id=? AND lnk.session_id=?");
        this.listAccessTypesForSession = conn.prepareStatement("SELECT DISTINCT def.user_type  FROM tp2_sessions_results lnk, tp2_definitions def WHERE def.id=lnk.def_id AND lnk.session_id=?");
        this.listAccessTypes = conn.prepareStatement("SELECT DISTINCT user_type  FROM tp2_definitions");
        this.listServerNodesForSessionTP = conn.prepareStatement("SELECT DISTINCT h.id,h.host_name,h.os_name,h.os_version,h.memory_mb,h.processor_count,h.processor_mhz FROM servernodes h, tp2_sessions_results lnk, tp2_definitions def WHERE h.id=def.servernode_id AND lnk.def_id=def.id AND lnk.session_id=?");
        this.listTp2CasesForSession = conn.prepareStatement("SELECT cases.state,cases.case_type,cases.begin_date AS case_begin,cases.end_date AS case_end,h.id AS host_id,h.host_name,h.os_name,h.os_version,h.memory_mb,h.processor_count,h.processor_mhz FROM tp2_sessions_servernodes cases, servernodes h WHERE h.id = cases.servernode_id AND cases.session_id=?");
        this.moveResultsForServerNode = conn.prepareStatement("UPDATE tp2_sessions_results SET session_id=? WHERE def_id IN  (SELECT def.id  FROM tp2_definitions def, tp2_sessions_results lnk WHERE lnk.def_id=def.id AND lnk.session_id=? AND def.servernode_id=?)");
        this.moveResultsForServerNodeAndDBDesc = conn.prepareStatement("UPDATE tp2_sessions_results SET session_id=? WHERE def_id IN  (SELECT def.id  FROM tp2_definitions def, tp2_sessions_results lnk WHERE lnk.def_id=def.id AND lnk.session_id=? AND def.servernode_id=? AND def.dbdescription_id=?)");
        this.insertSessionComment = conn.prepareStatement("INSERT INTO session_comments SET comment=?, session_id=?");
        this.updateSessionComment = conn.prepareStatement("UPDATE session_comments SET comment=? WHERE session_id=?");
        this.readSessionComment = conn.prepareStatement("SELECT comment FROM session_comments WHERE session_id=?");
        this.removeSessionComment = conn.prepareStatement("DELETE FROM session_comments WHERE session_id=?");
    }

    private synchronized void lock(PreparedStatement stmt) {
        long loopBegin = System.currentTimeMillis();
        while (this.locks.contains(stmt)) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - loopBegin <= 10000L) continue;
                this.locks.remove(stmt);
                System.err.println("Removed statement " + stmt + " from locks after " + (System.currentTimeMillis() - loopBegin) + " ms.");
                break;
            }
            catch (InterruptedException e) {
            }
        }
        this.locks.add(stmt);
        this.notifyAll();
    }

    private synchronized void unlock(PreparedStatement stmt) {
        if (this.locks.contains(stmt)) {
            this.locks.remove(stmt);
        }
        this.notifyAll();
    }

    public SortedSet listServerNodes(Session session) throws SQLException {
        this.lock(this.listServerNodesForSessionTP);
        TreeSet<ServerNode> res = new TreeSet<ServerNode>();
        this.listServerNodesForSessionTP.setInt(1, session.getId());
        ResultSet RS = this.listServerNodesForSessionTP.executeQuery();
        while (RS.next()) {
            res.add(new ServerNode(RS.getInt("id"), RS.getString("host_name"), RS.getString("os_name"), RS.getString("os_version"), RS.getInt("memory_mb"), RS.getInt("processor_count"), RS.getString("processor_mhz")));
        }
        RS.close();
        this.unlock(this.listServerNodesForSessionTP);
        return res;
    }

    public SortedSet listDBDescs(Session session, ServerNode serverNode) throws SQLException {
        this.lock(this.listDBDescsForSessionAndServerNodeTP);
        TreeSet<DBDescription> res = new TreeSet<DBDescription>();
        this.listDBDescsForSessionAndServerNodeTP.setInt(1, session.getId());
        this.listDBDescsForSessionAndServerNodeTP.setInt(2, serverNode.getId());
        ResultSet RS = this.listDBDescsForSessionAndServerNodeTP.executeQuery();
        while (RS.next()) {
            res.add(new DBDescription(RS.getInt("id"), RS.getInt("major"), RS.getInt("minor"), RS.getInt("correction_level"), RS.getString("build"), RS.getInt("dbparameters_id"), RS.getInt("maxcpu")));
        }
        RS.close();
        this.unlock(this.listDBDescsForSessionAndServerNodeTP);
        return res;
    }

    public SortedSet listAccessTypes(Session session, ServerNode serverNode) throws SQLException, Tp2Exception {
        this.lock(this.listAccessTypesForSessionAndServerNode);
        TreeSet<AccessType> res = new TreeSet<AccessType>();
        this.listAccessTypesForSessionAndServerNode.setInt(1, serverNode.getId());
        this.listAccessTypesForSessionAndServerNode.setInt(2, session.getId());
        ResultSet RS = this.listAccessTypesForSessionAndServerNode.executeQuery();
        while (RS.next()) {
            res.add(new AccessType(RS.getString("user_type")));
        }
        RS.close();
        this.unlock(this.listAccessTypesForSessionAndServerNode);
        return res;
    }

    public SortedSet listAccessTypes(Session session) throws SQLException, Tp2Exception {
        this.lock(this.listAccessTypesForSession);
        TreeSet<AccessType> res = new TreeSet<AccessType>();
        this.listAccessTypesForSession.setInt(1, session.getId());
        ResultSet RS = this.listAccessTypesForSession.executeQuery();
        while (RS.next()) {
            res.add(new AccessType(RS.getString("user_type")));
        }
        RS.close();
        this.unlock(this.listAccessTypesForSession);
        return res;
    }

    public SortedSet listAccessTypes() throws SQLException, Tp2Exception {
        this.lock(this.listAccessTypes);
        TreeSet<AccessType> res = new TreeSet<AccessType>();
        ResultSet RS = this.listAccessTypes.executeQuery();
        while (RS.next()) {
            res.add(new AccessType(RS.getString("user_type")));
        }
        RS.close();
        this.unlock(this.listAccessTypes);
        return res;
    }

    public SortedSet listSessions(User user) throws SQLException {
        Session sess;
        TreeSet<Session> res = new TreeSet<Session>();
        this.lock(this.listSessionsForUserTP);
        this.listSessionsForUserTP.setInt(1, user.getId());
        this.listSessionsForUserTP.setInt(2, user.getId());
        ResultSet RS = this.listSessionsForUserTP.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("id"), RS.getString("description"), user, RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForUserTP);
        this.lock(this.listSessionsForUserWisc);
        this.listSessionsForUserWisc.setInt(1, user.getId());
        this.listSessionsForUserWisc.setInt(2, user.getId());
        RS = this.listSessionsForUserWisc.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("id"), RS.getString("description"), user, RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForUserWisc);
        return res;
    }

    public SortedSet listSessions(ServerNode host) throws SQLException {
        Session sess;
        TreeSet<Session> res = new TreeSet<Session>();
        this.lock(this.listSessionsForServerNodeTP);
        this.listSessionsForServerNodeTP.setInt(1, host.getId());
        ResultSet RS = this.listSessionsForServerNodeTP.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForServerNodeTP);
        this.lock(this.listSessionsForServerNodeWisc);
        this.listSessionsForServerNodeWisc.setInt(1, host.getId());
        RS = this.listSessionsForServerNodeWisc.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForServerNodeWisc);
        return res;
    }

    public SortedSet listSessions(DBDescription dbDesc) throws SQLException {
        Session sess;
        TreeSet<Session> res = new TreeSet<Session>();
        this.lock(this.listSessionsForDBDescTP);
        this.listSessionsForDBDescTP.setInt(1, dbDesc.getId());
        ResultSet RS = this.listSessionsForDBDescTP.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForDBDescTP);
        this.lock(this.listSessionsForDBDescWisc);
        this.listSessionsForDBDescWisc.setInt(1, dbDesc.getId());
        RS = this.listSessionsForDBDescWisc.executeQuery();
        while (RS.next()) {
            sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listSessionsForDBDescWisc);
        return res;
    }

    public SortedSet listOpenSessions() throws SQLException {
        this.lock(this.listOpenSessions);
        TreeSet<Session> res = new TreeSet<Session>();
        ResultSet RS = this.listOpenSessions.executeQuery();
        while (RS.next()) {
            Session sess = new Session(RS.getInt("sess_id"), RS.getString("sess_desc"), new User(RS.getInt("user_id"), RS.getString("user_name"), RS.getString("user_desc"), RS.getString("user_mail")), RS.getString("benchmark_type"), RS.getTimestamp("begin_date"), RS.getTimestamp("end_date"));
            sess.setRelatedTestsCount(RS.getInt("tests_count"));
            res.add(sess);
        }
        RS.close();
        this.unlock(this.listOpenSessions);
        return res;
    }

    public SortedSet listSessionIdsForBench(String benchmarkType) throws SQLException {
        this.lock(this.listSessionIdsForBench);
        this.listSessionIdsForBench.setString(1, benchmarkType);
        TreeSet<CompInt> res = new TreeSet<CompInt>();
        ResultSet RS = this.listSessionIdsForBench.executeQuery();
        while (RS.next()) {
            res.add(new CompInt(RS.getInt("id"), false));
        }
        RS.close();
        this.unlock(this.listSessionIdsForBench);
        return res;
    }

    public SortedSet listUsers() throws SQLException {
        this.lock(this.listUsers);
        TreeSet<User> res = new TreeSet<User>();
        ResultSet RS = this.listUsers.executeQuery();
        while (RS.next()) {
            res.add(new User(RS.getInt("id"), RS.getString("name"), RS.getString("description"), RS.getString("mail")));
        }
        RS.close();
        this.unlock(this.listUsers);
        return res;
    }

    public SortedSet listShortBuilds() throws SQLException {
        this.lock(this.listShortBuilds);
        TreeSet<ShortBuild> res = new TreeSet<ShortBuild>();
        ResultSet RS = this.listShortBuilds.executeQuery();
        while (RS.next()) {
            res.add(new ShortBuild(new Version(RS.getInt("major"), RS.getInt("minor"), RS.getInt("correction_level")), RS.getString("short_build")));
        }
        RS.close();
        this.unlock(this.listShortBuilds);
        return res;
    }

    public SortedMap listServerNodesByOsName() throws SQLException {
        this.lock(this.listServerNodes);
        TreeMap res = new TreeMap();
        ResultSet RS = this.listServerNodes.executeQuery();
        while (RS.next()) {
            ServerNode sn = new ServerNode(RS.getInt("id"), RS.getString("host_name") + "_id" + RS.getInt("id"), RS.getString("os_name"), RS.getString("os_version"), RS.getInt("memory_mb"), RS.getInt("processor_count"), RS.getString("processor_mhz"));
            if (!res.containsKey(sn.getOsName())) {
                res.put(sn.getOsName(), new TreeSet());
            }
            ((SortedSet)res.get(sn.getOsName())).add(sn);
        }
        RS.close();
        this.unlock(this.listServerNodes);
        return res;
    }

    public SortedSet listServerNodes() throws SQLException {
        this.lock(this.listServerNodes);
        TreeSet<ServerNode> res = new TreeSet<ServerNode>();
        ResultSet RS = this.listServerNodes.executeQuery();
        while (RS.next()) {
            ServerNode sn = new ServerNode(RS.getInt("id"), RS.getString("host_name") + "_id" + RS.getInt("id"), RS.getString("os_name"), RS.getString("os_version"), RS.getInt("memory_mb"), RS.getInt("processor_count"), RS.getString("processor_mhz"));
            res.add(sn);
        }
        RS.close();
        this.unlock(this.listServerNodes);
        return res;
    }

    public SortedSet listTp2Cases(Session session) throws SQLException {
        this.lock(this.listTp2CasesForSession);
        TreeSet<Tp2Case> res = new TreeSet<Tp2Case>();
        this.listTp2CasesForSession.setInt(1, session.getId());
        ResultSet RS = this.listTp2CasesForSession.executeQuery();
        while (RS.next()) {
            ServerNode host = new ServerNode(RS.getInt("host_id"), RS.getString("host_name"), RS.getString("os_name"), RS.getString("os_version"), RS.getInt("memory_mb"), RS.getInt("processor_count"), RS.getString("processor_mhz"));
            res.add(new Tp2Case(session, host, RS.getString("case_type"), RS.getTimestamp("case_begin"), RS.getTimestamp("case_end"), RS.getString("state")));
        }
        RS.close();
        this.unlock(this.listTp2CasesForSession);
        return res;
    }

    public SortedSet listBenchmarkTypes() throws SQLException, Tp2Exception {
        this.lock(this.listBenchmarkTypes);
        TreeSet<String> res = new TreeSet<String>();
        ResultSet RS = this.listBenchmarkTypes.executeQuery();
        while (RS.next()) {
            res.add(RS.getString("benchmark_type"));
        }
        RS.close();
        this.unlock(this.listBenchmarkTypes);
        return res;
    }

    public void moveResults(int newSessionId, int oldSessionId, int serverNodeId) throws SQLException {
        this.lock(this.moveResultsForServerNode);
        this.moveResultsForServerNode.setInt(1, newSessionId);
        this.moveResultsForServerNode.setInt(2, oldSessionId);
        this.moveResultsForServerNode.setInt(3, serverNodeId);
        this.moveResultsForServerNode.executeUpdate();
        this.moveResultsForServerNode.getConnection().commit();
        this.unlock(this.moveResultsForServerNode);
    }

    public void moveResults(int newSessionId, int oldSessionId, int serverNodeId, int dbDescriptionId) throws SQLException {
        this.lock(this.moveResultsForServerNodeAndDBDesc);
        this.moveResultsForServerNodeAndDBDesc.setInt(1, newSessionId);
        this.moveResultsForServerNodeAndDBDesc.setInt(2, oldSessionId);
        this.moveResultsForServerNodeAndDBDesc.setInt(3, serverNodeId);
        this.moveResultsForServerNodeAndDBDesc.setInt(4, dbDescriptionId);
        this.moveResultsForServerNodeAndDBDesc.executeUpdate();
        this.moveResultsForServerNodeAndDBDesc.getConnection().commit();
        this.unlock(this.moveResultsForServerNodeAndDBDesc);
    }

    public String readSessionComment(int sessionId) throws SQLException, Tp2Exception {
        String result = null;
        this.lock(this.readSessionComment);
        this.readSessionComment.setInt(1, sessionId);
        ResultSet RS = this.readSessionComment.executeQuery();
        if (RS.next()) {
            result = RS.getString("comment");
        }
        RS.close();
        this.unlock(this.readSessionComment);
        return result;
    }

    public void writeSessionComment(int sessionId, String comment) throws SQLException, Tp2Exception {
        if (this.readSessionComment(sessionId) == null) {
            this.lock(this.insertSessionComment);
            this.insertSessionComment.setString(1, comment);
            this.insertSessionComment.setInt(2, sessionId);
            this.insertSessionComment.executeUpdate();
            this.insertSessionComment.getConnection().commit();
            this.unlock(this.insertSessionComment);
        } else if (comment == null || comment.equals("")) {
            this.lock(this.removeSessionComment);
            this.removeSessionComment.setInt(1, sessionId);
            this.removeSessionComment.executeUpdate();
            this.removeSessionComment.getConnection().commit();
            this.unlock(this.removeSessionComment);
        } else {
            this.lock(this.updateSessionComment);
            this.updateSessionComment.setString(1, comment);
            this.updateSessionComment.setInt(2, sessionId);
            this.updateSessionComment.executeUpdate();
            this.updateSessionComment.getConnection().commit();
            this.unlock(this.updateSessionComment);
        }
    }

    public static String convDate(Date date) {
        if (date == null) {
            return "-";
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return LcBenchmarkResultsEnv.formatNbr(cal.get(5)) + "." + LcBenchmarkResultsEnv.formatNbr(cal.get(2) + 1) + "." + LcBenchmarkResultsEnv.formatNbr(cal.get(1) % 100) + " " + LcBenchmarkResultsEnv.formatNbr(cal.get(11)) + "h" + LcBenchmarkResultsEnv.formatNbr(cal.get(12));
    }

    public static int convDate(Timestamp ts) {
        if (ts == null) {
            return -1;
        }
        return ts.getDate();
    }

    public static int[] convIntList(String[] idList) {
        Vector<Integer> buf = new Vector<Integer>();
        for (int i = 0; i < idList.length; ++i) {
            buf.add(new Integer(Integer.parseInt(idList[i])));
        }
        int[] res = new int[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            res[i] = (Integer)buf.get(i);
        }
        return res;
    }

    public static int[] convIntList(String param, String separator) {
        StringTokenizer ST = new StringTokenizer(param, separator);
        Vector<Integer> buf = new Vector<Integer>();
        while (ST.hasMoreTokens()) {
            buf.add(new Integer(Integer.parseInt(ST.nextToken())));
        }
        int[] res = new int[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            res[i] = (Integer)buf.get(i);
        }
        return res;
    }

    public static String formatNbr(int nbr) {
        if (nbr < 10) {
            return "0" + nbr;
        }
        return Integer.toString(nbr);
    }

    public static String formatDuration(long duration) {
        if (duration / 1000L > 0L) {
            return duration / 1000L + "s " + duration % 1000L + "ms";
        }
        return duration + "ms";
    }
}

