/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.design.DataBaseNode;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.ReplicationTable;
import com.sap.sdb.syncMan.design.SchemaNode;
import com.sap.sdb.syncMan.design.ServerNode;
import com.sap.sdb.syncMan.tool.ConDataBase;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReplicationTableDialog
extends Dialog {
    int colWidth = 200;
    private Text _tableFilter;
    private Combo _schemas;
    private List _tables;
    private ConDataBase _con;
    private Vector _repTables;
    private Participant _particpant;
    private ServerNode _hostNode;
    private DataBaseNode _dbNode;

    public ReplicationTableDialog(Shell parentShell, ConDataBase con, Participant particpant) {
        super(parentShell);
        this._con = con;
        this._particpant = particpant;
        this._hostNode = new ServerNode(this._particpant.getHost());
        this._dbNode = new DataBaseNode(this._hostNode, this._particpant.getDataBase());
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Import Tables");
    }

    protected Control createButtonBar(Composite parent) {
        Composite comp = (Composite)super.createButtonBar(parent);
        this.createButton(comp, "Refresh");
        return comp;
    }

    private Button createButton(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ReplicationTableDialog.this._schemas.getItemCount() > 0) {
                    SchemaNode schemaNode = new SchemaNode(ReplicationTableDialog.this._dbNode, ReplicationTableDialog.this._schemas.getItem(ReplicationTableDialog.this._schemas.getSelectionIndex()));
                    ReplicationTableDialog.this.addTablesOfSchema(schemaNode, ReplicationTableDialog.this._tableFilter.getText());
                }
            }
        });
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(1808));
        Label tableTables = new Label(page, 0);
        tableTables.setText("Tables:");
        this._tables = new List(page, 2818);
        GridData gridData = new GridData(1808);
        int listHeight = this._tables.getItemHeight() * 10;
        Rectangle trim = this._tables.computeTrim(0, 0, this.colWidth, listHeight);
        gridData.heightHint = trim.height;
        gridData.widthHint = trim.width;
        this._tables.setLayoutData((Object)gridData);
        this._tables.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ReplicationTableDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Label tableFilterTable = new Label(page, 0);
        tableFilterTable.setText("Table Name:");
        this._tableFilter = new Text(page, 2048);
        this._tableFilter.setText("%");
        gridData = new GridData(768);
        trim = this._tables.computeTrim(0, 0, this.colWidth, 0);
        gridData.widthHint = trim.width;
        this._tableFilter.setLayoutData((Object)gridData);
        Label schemaLabel = new Label(page, 0);
        schemaLabel.setText("Table Schema:");
        this._schemas = new Combo(page, 12);
        this._schemas.setText("");
        this._schemas.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReplicationTableDialog.this._schemas.getItemCount() > 0) {
                    SchemaNode schemaNode = new SchemaNode(ReplicationTableDialog.this._dbNode, ReplicationTableDialog.this._schemas.getItem(ReplicationTableDialog.this._schemas.getSelectionIndex()));
                    ReplicationTableDialog.this.addTablesOfSchema(schemaNode, ReplicationTableDialog.this._tableFilter.getText());
                }
            }
        });
        gridData = new GridData(1808);
        trim = this._tables.computeTrim(0, 0, this.colWidth, 0);
        gridData.widthHint = trim.width;
        this._schemas.setLayoutData((Object)gridData);
        this.addSchemas();
        if (this._schemas.getItemCount() > 0) {
            SchemaNode schemaNode = new SchemaNode(this._dbNode, this._schemas.getItem(this._schemas.getSelectionIndex()));
            this.addTablesOfSchema(schemaNode, this._tableFilter.getText());
        }
        return page;
    }

    protected void okPressed() {
        this.applySelectedTables();
        super.okPressed();
    }

    private void addSchemas() {
        try {
            Vector schemas = DesignSQLLayer.selectRepTableSchema(this._con, this._dbNode);
            for (int i = 0; i < schemas.size(); ++i) {
                this._schemas.add(schemas.get(i).toString());
            }
            if (this._schemas.getItemCount() > 0) {
                this._schemas.select(0);
            }
        }
        catch (SQLException ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
        }
    }

    private void addTablesOfSchema(SchemaNode schemaNode, String filter) {
        this._tables.removeAll();
        try {
            this._repTables = DesignSQLLayer.selectRepTables(this._con, schemaNode, filter);
            for (int i = 0; i < this._repTables.size(); ++i) {
                this._tables.add(this._repTables.get(i).toString());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void applySelectedTables() {
        int[] selectedTables = this._tables.getSelectionIndices();
        for (int i = 0; i < selectedTables.length; ++i) {
            ReplicationTable table = (ReplicationTable)this._repTables.get(selectedTables[i]);
            try {
                table.loadColumnGroups(this._con);
                DesignSQLLayer.tableForReplication(this._con, this._particpant.getDesignID(), table);
                this._con.getConnection().commit();
                continue;
            }
            catch (Exception ex) {
                try {
                    this._con.getConnection().rollback();
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                    continue;
                }
                catch (Exception ex2) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.toString());
                }
            }
        }
    }
}

