/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.Resources;
import java.sql.SQLException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParticipantConfigDialog
extends Dialog {
    private Combo m_JDBCDriverText;
    private Button m_UseSSLButton;
    ConDataBase m_Con = null;
    ParticipantConfig m_ParticpantConfig = null;

    public ParticipantConfigDialog(Shell parentShell, ConDataBase con, ParticipantConfig particpantConfig) {
        super(parentShell);
        this.m_Con = con;
        this.m_ParticpantConfig = particpantConfig;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.getString("Units.Participant") + " " + Resources.getString("Config.Configuration"));
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        page.setLayout((Layout)gridLayout);
        Group configGroup = new Group(page, 0);
        configGroup.setText(Resources.getString("Config.Configuration"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        configGroup.setLayout((Layout)gridLayout);
        this.m_UseSSLButton = new Button((Composite)configGroup, 32);
        this.m_UseSSLButton.setText("SSL Connection");
        this.m_UseSSLButton.setSelection(this.m_ParticpantConfig.getUseSSL());
        Label lblJDBCDriverText = new Label((Composite)configGroup, 0);
        lblJDBCDriverText.setText(Resources.getString("Config.JDBC_Driver"));
        this.m_JDBCDriverText = new Combo((Composite)configGroup, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        this.m_JDBCDriverText.add(Resources.getString("ParticipantConfigDialog.com.sap.dbtech.jdbc.DriverSapDB"));
        this.m_JDBCDriverText.add(Resources.getString("ParticipantConfigDialog.com.sap.sdb.minDB.DriverMinDB"));
        this.m_JDBCDriverText.add(Resources.getString("ParticipantConfigDialog.com.sap.sdb.minDB.DriverEmbeddedMinDB"));
        this.m_JDBCDriverText.add(Resources.getString("ParticipantConfigDialog.com.mysql.jdbc.Driver"));
        this.m_JDBCDriverText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ParticipantConfigDialog.this.m_JDBCDriverText.getSelectionIndex() == 1) {
                    ParticipantConfigDialog.this.m_UseSSLButton.setSelection(false);
                    ParticipantConfigDialog.this.m_UseSSLButton.setEnabled(false);
                } else {
                    ParticipantConfigDialog.this.m_UseSSLButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ParticipantConfigDialog.this.m_JDBCDriverText.getSelectionIndex() == 1) {
                    ParticipantConfigDialog.this.m_UseSSLButton.setSelection(false);
                    ParticipantConfigDialog.this.m_UseSSLButton.setEnabled(false);
                } else {
                    ParticipantConfigDialog.this.m_UseSSLButton.setEnabled(true);
                }
            }
        });
        this.m_JDBCDriverText.setLayoutData((Object)gridData);
        if (this.m_ParticpantConfig.jdbcDriver().equalsIgnoreCase(Resources.getString("ParticipantConfigDialog.com.sap.dbtech.jdbc.DriverSapDB"))) {
            this.m_JDBCDriverText.select(0);
        } else if (this.m_ParticpantConfig.jdbcDriver().equalsIgnoreCase(Resources.getString("ParticipantConfigDialog.com.sap.sdb.minDB.DriverMinDB"))) {
            this.m_UseSSLButton.setSelection(false);
            this.m_UseSSLButton.setEnabled(false);
            this.m_JDBCDriverText.select(1);
        } else if (this.m_ParticpantConfig.jdbcDriver().equalsIgnoreCase(Resources.getString("ParticipantConfigDialog.com.sap.sdb.minDB.DriverEmbeddedMinDB"))) {
            this.m_UseSSLButton.setSelection(false);
            this.m_UseSSLButton.setEnabled(false);
            this.m_JDBCDriverText.select(2);
        } else if (this.m_ParticpantConfig.jdbcDriver().equalsIgnoreCase(Resources.getString("ParticipantConfigDialog.com.mysql.jdbc.Driver"))) {
            this.m_JDBCDriverText.select(3);
        } else {
            this.m_JDBCDriverText.select(0);
        }
        return page;
    }

    protected void okPressed() {
        if (this.m_JDBCDriverText.getText().length() < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantConfigDialog.Error"), (String)Resources.getString("General.Valid_Data"));
            this.m_JDBCDriverText.setFocus();
            return;
        }
        if (!this.applyParticpantConfig()) {
            return;
        }
        super.okPressed();
    }

    private boolean applyParticpantConfig() {
        try {
            this.m_ParticpantConfig.setJDBCDriver(this.m_JDBCDriverText.getText());
            this.m_ParticpantConfig.setUseSSL(this.m_UseSSLButton.getSelection());
            DesignSQLLayer.alterParticipantConfig(this.m_Con, this.m_ParticpantConfig);
            this.m_Con.getConnection().commit();
        }
        catch (Exception ex) {
            try {
                this.m_Con.getConnection().rollback();
            }
            catch (SQLException ex2) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("General.Error"), (String)ex2.toString());
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("General.Error"), (String)ex.toString());
            return false;
        }
        return true;
    }
}

