/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.design;

import com.sap.sdb.syncMan.util.ColumnDesc;

public class Column {
    private long mColumnID;
    private String mColumnName;
    private int mPrecision;
    private int mScale;
    private int mSqlType;
    private String mTypeName;
    private int mKeyPos;
    private int mPos;
    private int mConstraintType;
    private String mConstraintValue1;
    private String mConstraintValue2;
    private String mMasterColumnName;
    private static final String[] mNoConstraint = new String[0];
    private static final String[] mNumericConstraint = new String[]{ColumnDesc.constraints[0], ColumnDesc.constraints[1], ColumnDesc.constraints[2], ColumnDesc.constraints[3], ColumnDesc.constraints[4], ColumnDesc.constraints[5], ColumnDesc.constraints[6], ColumnDesc.constraints[7], ColumnDesc.constraints[8], ColumnDesc.constraints[9]};
    private static final String[] mCharConstraint = ColumnDesc.constraints;

    public Column(long columnID, String columnName, int sqlType, String type_name, int precision, int scale, int pos, int keyPos, int constraintType, String constraintValue1, String constraintValue2) {
        this.mColumnName = columnName;
        this.mColumnID = columnID;
        this.mKeyPos = keyPos;
        this.mSqlType = sqlType;
        this.mPrecision = precision;
        this.mScale = scale;
        this.mTypeName = type_name;
        this.mPos = pos;
        this.mConstraintType = constraintType;
        this.mConstraintValue1 = constraintValue1;
        this.mConstraintValue2 = constraintValue2;
    }

    public Object cloneColumn() {
        return new Column(this.mColumnID, this.mColumnName, this.mSqlType, this.mTypeName, this.mPrecision, this.mScale, this.mPos, this.mKeyPos, this.mConstraintType, this.mConstraintValue1, this.mConstraintValue2);
    }

    public long columnID() {
        return this.mColumnID;
    }

    public String columnName() {
        return this.mColumnName;
    }

    public int keyPos() {
        return this.mKeyPos;
    }

    public int pos() {
        return this.mPos;
    }

    public int precision() {
        return this.mPrecision;
    }

    public int scale() {
        return this.mScale;
    }

    public void setColumnName(String columnName) {
        this.mColumnName = columnName;
    }

    public int sqlType() {
        return this.mSqlType;
    }

    public String typeName() {
        return this.mTypeName;
    }

    public int constraintType() {
        return this.mConstraintType;
    }

    public void setConstraintType(int constraintType) {
        this.mConstraintType = constraintType;
        if (this.sqlType() == 2004 || this.sqlType() == -1 || this.sqlType() == -4 || this.sqlType() == -3 || this.sqlType() == 2005) {
            this.mConstraintType = 0;
        }
        if (this.mConstraintType == 0) {
            this.mConstraintValue1 = "";
            this.mConstraintValue2 = "";
        }
    }

    public String constraintValue1() {
        return this.mConstraintValue1;
    }

    public void setConstraintValue1(String constraintValue1) {
        this.mConstraintValue1 = constraintValue1;
    }

    public void setConstraintValue2(String constraintValue2) {
        this.mConstraintValue2 = constraintValue2;
    }

    public String constraintValue2() {
        return this.mConstraintValue2;
    }

    public String toString() {
        return this.mColumnName;
    }

    public String[] possibleColumnConstraints() {
        if (this.sqlType() == 2004 || this.sqlType() == -1 || this.sqlType() == -4 || this.sqlType() == -3 || this.sqlType() == 2005) {
            return mNoConstraint;
        }
        if (this.sqlType() == 1 || this.sqlType() == 12) {
            return mCharConstraint;
        }
        return mNumericConstraint;
    }

    public void setMasterColumnName(String masterColName) {
        this.mMasterColumnName = masterColName;
    }

    public String masterColumnName() {
        return this.mMasterColumnName;
    }

    public String getConstaintExpression() {
        String sql = "";
        if (this.mConstraintType != 0) {
            sql = this.mConstraintType == 8 || this.mConstraintType == 9 ? ColumnDesc.constraints[this.mConstraintType] + "(" + this.mConstraintValue1 + ")" : ColumnDesc.constraints[this.mConstraintType] + " " + this.getFormateValue(this.mConstraintValue1);
            if (this.mConstraintType == 7) {
                sql = sql + " AND " + this.getFormateValue(this.mConstraintValue2);
            }
        }
        return sql;
    }

    private String getFormateValue(String mConstraintValue) {
        if (this.mSqlType == 5 || this.mSqlType == 4 || this.mSqlType == 8 || this.mSqlType == 3 || this.mSqlType == 6 || this.mSqlType == 2 || this.mSqlType == 7) {
            return mConstraintValue;
        }
        if (this.mSqlType == -2 || this.mSqlType == -3 || this.mSqlType == -4) {
            return "X'" + mConstraintValue + "'";
        }
        return "'" + mConstraintValue + "'";
    }
}

