/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav;

import com.sap.sapdb.testframe.utilities.webdav.WebDAVClient;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpeicherListeXML {
    WebDAVClient client = null;
    File file = null;
    protected String resource = "";
    protected String base = "http://pts:1080/webdav/";
    protected String filename = "C:/temp/SpeicherListe.xml";
    protected int timeout = 60;
    boolean stop = false;
    NumberFormat nf = NumberFormat.getInstance(new Locale("de"));
    Document doc = null;

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }

    public static void main(String[] args) {
        new SpeicherListeXML(args);
    }

    public SpeicherListeXML(String[] args) {
        try {
            this.parseParameters(args);
            this.doc = SpeicherListeXML.newDocument();
            URL url = new URL(this.base);
            this.client = new WebDAVClient(url);
            this.file = new File(this.filename);
            this.file.createNewFile();
            System.out.println("Use output file: " + this.file.toString());
            Element el = this.doc.createElement("Scan");
            el.setAttribute("Directory", this.base);
            el.setAttribute("StartTime", new Date().toString());
            this.doc.appendChild(el);
            System.out.println("Start scan of " + this.base);
            this.readStandardInput();
            this.scanFile(this.resource, el);
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Data scanFile(String resource, Element parent) throws Exception {
        System.out.println(resource);
        Vector vCollections = null;
        Vector vFiles = null;
        WebDAVFile[] aFiles = null;
        Element el = this.doc.createElement("Folder");
        parent.appendChild(el);
        Data data = new Data();
        data.scantime = new Date();
        try {
            int i;
            vCollections = this.client.list(resource, 0, this.timeout);
            vFiles = this.client.getLastSizeVector();
            if (vCollections != null) {
                aFiles = new WebDAVFile[vFiles.size()];
                for (int j = 0; j < vFiles.size(); ++j) {
                    aFiles[j] = (WebDAVFile)vFiles.get(j);
                }
                if (aFiles.length > 0) {
                    int size = vCollections.size();
                    int offset = 0;
                    block3: for (int i2 = 0; i2 < size; ++i2) {
                        String name = (String)vCollections.get(i2 - offset);
                        for (int j = 0; j < aFiles.length; ++j) {
                            if (!aFiles[j].getName().equals(name)) continue;
                            vCollections.remove(i2 - offset);
                            ++offset;
                            continue block3;
                        }
                    }
                }
                data.subfoldersCount = vCollections.size() - 1;
                for (i = 1; i < vCollections.size() && !this.stop; ++i) {
                    Data sub = this.scanFile(resource + vCollections.elementAt(i).toString() + "/", el);
                    data.subfoldersSize += sub.folderSize + sub.subfoldersSize;
                    data.subfoldersFileCount += sub.fileCount + sub.subfoldersFileCount;
                    data.subfoldersCount += sub.subfoldersCount;
                    data.emptySubfolders += sub.emptySubfolders;
                    if (sub.fileCount != 0 || sub.subfoldersCount != 0) continue;
                    ++data.emptySubfolders;
                }
            }
            if (vCollections != null) {
                data.fileCount = aFiles.length;
                for (i = 0; i < aFiles.length; ++i) {
                    Element file = this.doc.createElement("File");
                    file.setAttribute("Name", aFiles[i].getName());
                    file.setAttribute("Size", this.nf.format(aFiles[i].getSize()));
                    el.appendChild(file);
                }
            }
            data.folderSize = this.client.getLastSize();
            if (!this.stop && data.fileCount == 0 && data.subfoldersCount == 0) {
                data.isEmpty = true;
            }
        }
        catch (WebDAVException e) {
            System.err.println(e.getMessage());
        }
        this.writeLink(resource, el, data);
        return data;
    }

    public void writeLink(String resource, Element el, Data data) throws Exception {
        el.setAttribute("Name", resource);
        if (data.isEmpty) {
            el.setAttribute("isEmpty", "yes");
        } else {
            el.setAttribute("sFiles", this.nf.format(data.folderSize));
            el.setAttribute("sSubFolders", this.nf.format(data.subfoldersSize));
            el.setAttribute("nFiles", this.nf.format(data.fileCount));
            el.setAttribute("nSubFolders", this.nf.format(data.subfoldersCount));
            el.setAttribute("nSubFolderE", this.nf.format(data.emptySubfolders));
            el.setAttribute("nSubFolderFiles", this.nf.format(data.subfoldersFileCount));
        }
    }

    protected void readStandardInput() {
        Thread readThread = new Thread(){

            public void run() {
                while (!SpeicherListeXML.this.stop) {
                    byte[] buffer = new byte[20];
                    int length = 0;
                    try {
                        length = System.in.read(buffer);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    String st = null;
                    if (length != -1) {
                        st = new String(buffer, 0, length).toLowerCase();
                    }
                    System.out.println("Read " + st);
                    if (!st.trim().toLowerCase().matches("(stop)|(exit)|(halt)|(quit)|(end)")) continue;
                    System.out.println("Exit");
                    SpeicherListeXML.this.stop = true;
                }
            }
        };
        readThread.setDaemon(true);
        readThread.start();
    }

    protected void stop() throws TransformerConfigurationException, TransformerException {
        String endtime = new Date().toString();
        if (this.stop) {
            this.doc.getDocumentElement().setAttribute("Aborted", endtime);
        } else {
            this.doc.getDocumentElement().setAttribute("Finished", endtime);
        }
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("indent", "yes");
        tf.transform(new DOMSource(this.doc), new StreamResult(this.file));
        System.out.println("Finished at " + endtime);
        if (this.stop) {
            System.exit(1);
        }
    }

    protected void parseParameters(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
                this.filename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-t")) {
                if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
                try {
                    this.timeout = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException ex) {
                    System.err.println("Timeout value have to be an integer. Timeout will be set to " + this.timeout + "s.");
                }
                ++i;
                continue;
            }
            if (args[i].equals("-d")) {
                if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
                this.base = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].startsWith("-")) continue;
            System.out.println("Unknown option " + args[i]);
        }
        System.out.println(this.base + " " + this.filename + " " + this.timeout);
    }

    protected void printHelp() {
        System.out.println("Scan WebDAV directories recursive and print the tree in a XML file.\n");
    }

    public class Data {
        public int fileCount = 0;
        public long folderSize = 0L;
        public long subfoldersSize = 0L;
        public int subfoldersFileCount = 0;
        public int subfoldersCount = 0;
        public int emptySubfolders = 0;
        public Date scantime = null;
        public boolean isEmpty = false;
    }
}

