/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.TestParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class TestParameter {
    private HashMap mParameterMap = new HashMap();
    private ArrayList mUnnamedParameterList = new ArrayList();
    private String mParamFilePath;
    private String mParamFileName;

    public TestParameter() {
    }

    public TestParameter(String pParamFilePath, String pParamFileName) throws TestParameterException {
        this();
        this.mParamFilePath = pParamFilePath;
        this.mParamFileName = pParamFileName;
        this.read();
    }

    public boolean getBooleanParameter(String pParameterName) throws TestParameterException {
        return Boolean.valueOf(this.getStringParameter(pParameterName).toLowerCase());
    }

    public char getCharParameter(String pParameterName) throws TestParameterException {
        return this.getStringParameter(pParameterName).charAt(0);
    }

    public float getFloatParameter(String pParameterName) throws TestParameterException, NumberFormatException {
        try {
            return Float.parseFloat(this.getStringParameter(pParameterName));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Parameter: " + pParameterName + ". Can not cast " + this.getStringParameter(pParameterName) + " to float");
        }
    }

    public int getIntParameter(String pParameterName) throws TestParameterException, NumberFormatException {
        try {
            return Integer.parseInt(this.getStringParameter(pParameterName));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Parameter: " + pParameterName + ". Can not cast " + this.getStringParameter(pParameterName) + " to int");
        }
    }

    public long getLongParameter(String pParameterName) throws TestParameterException, NumberFormatException {
        try {
            return Long.parseLong(this.getStringParameter(pParameterName));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Parameter: " + pParameterName + ". Can not cast " + this.getStringParameter(pParameterName) + " to long");
        }
    }

    public String getParametersAsString() {
        Iterator it = this.mParameterMap.entrySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("line.separator"));
        while (it.hasNext()) {
            sb.append(it.next().toString() + System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String getStringParameter(String pParameterName) throws TestParameterException {
        if (pParameterName == null) {
            throw new TestParameterException("Unknown test parameter: Null");
        }
        String lString = (String)this.mParameterMap.get(pParameterName.trim().toUpperCase());
        if (lString == null) {
            throw new TestParameterException("Unknown test parameter: " + pParameterName.trim().toUpperCase());
        }
        return lString;
    }

    public String getParameterFileLocation() {
        if (this.mParamFileName != null) {
            if (new File(this.mParamFilePath + System.getProperty("file.separator") + this.mParamFileName).exists()) {
                return this.mParamFilePath + System.getProperty("file.separator") + this.mParamFileName;
            }
            return null;
        }
        return null;
    }

    public ArrayList getUnnamedParameterList() {
        if (this.mUnnamedParameterList.isEmpty()) {
            return null;
        }
        return this.mUnnamedParameterList;
    }

    public HashMap getParameterList() {
        if (this.mParameterMap.isEmpty()) {
            return null;
        }
        return this.mParameterMap;
    }

    public static void main(String[] args) {
        try {
            TestParameter tp = new TestParameter("C:\\Temp\\", "TestPara.par");
            String s = tp.getStringParameter("TestSTRING");
            int i = tp.getIntParameter("testint");
            char c = tp.getCharParameter("Testchar");
            long l = tp.getLongParameter("testlong");
            boolean b = tp.getBooleanParameter("Testbool");
            float f = tp.getFloatParameter("testfloat");
            System.out.println(s + i + c + l + b + f);
        }
        catch (TestParameterException e) {
            System.out.println(e.getMessage());
        }
    }

    private synchronized boolean read() throws TestParameterException {
        String lFileName = this.mParamFilePath + System.getProperty("file.separator") + this.mParamFileName;
        String lKey = null;
        String lData = null;
        if (!this.mParameterMap.isEmpty()) {
            return false;
        }
        try {
            String lLine;
            BufferedReader in = new BufferedReader(new FileReader(lFileName));
            while ((lLine = in.readLine()) != null) {
                if (lLine.indexOf("#") >= 0) {
                    lLine = lLine.substring(0, lLine.indexOf("#"));
                }
                if ((lLine = lLine.trim()).length() <= 0) continue;
                if (lLine.indexOf("=") == -1) {
                    this.mUnnamedParameterList.add(lLine);
                    continue;
                }
                StringTokenizer lST = new StringTokenizer(lLine, "\t\n\r\f=");
                lKey = null;
                lData = null;
                if (lST.hasMoreTokens()) {
                    lKey = lST.nextToken().toUpperCase().trim();
                }
                if (lKey.indexOf(" ") != -1) {
                    this.mUnnamedParameterList.add(lLine);
                    continue;
                }
                lData = lST.nextToken().trim();
                if (lKey == null || lData == null) continue;
                this.setParameter(lKey, lData);
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            System.out.println(e.getClass() + " " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            throw new TestParameterException("Invalid parameter file syntax - Parameter: " + lKey);
        }
        return true;
    }

    public synchronized void setParameter(String pParameterName, String pParameterValue) {
        this.mParameterMap.put(pParameterName.trim().toUpperCase(), pParameterValue.trim());
    }
}

