/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ExplainConstants;
import com.sap.sapdb.testframe.testcase.ExplainData;
import com.sap.sapdb.testframe.testcase.ExplainDataIterator;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.ExplainException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class ExplainObject
implements Serializable,
ExplainConstants {
    private ExplainData mExplainData = null;
    private String mEqualsMessage;
    private static final long serialVersionUID = 24L;

    public ExplainObject() {
        this.mExplainData = new ExplainData();
    }

    public ExplainObject(String pSql, Connection pCon) throws SQLException, ExplainException {
        boolean hasExplain = false;
        boolean hasSelect = false;
        StringTokenizer st = new StringTokenizer(pSql);
        int tokenCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            ++tokenCounter;
            if (token.trim().equalsIgnoreCase("SELECT")) {
                hasSelect = true;
            }
            if (token.trim().equalsIgnoreCase("EXPLAIN")) {
                hasExplain = true;
            }
            if (tokenCounter <= 2) continue;
            break;
        }
        if (!hasSelect) {
            throw new ExplainException("Explain " + pSql + " not allowed");
        }
        String sql = hasExplain ? pSql : "Explain " + pSql;
        Statement stmt = pCon.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        this.mExplainData = new ExplainData(rs);
    }

    public ExplainObject(ResultSet rs) {
        this.mExplainData = new ExplainData(rs);
    }

    public void add() throws ExplainException {
        this.mExplainData.add();
    }

    public void addStrategy(String pStrategy) {
        this.mExplainData.addStrategy(pStrategy);
    }

    public void addStrategy(String pStrategy, String pColumn) {
        this.mExplainData.addStrategy(pStrategy, pColumn);
    }

    public void addStrategy(String pStrategy, String pColumn, boolean pOnlyIndex, boolean pDistinctOptimization, boolean pTemporaryInversion, boolean pMoreQualifications) {
        this.mExplainData.addStrategy(pStrategy, pColumn, pOnlyIndex, pDistinctOptimization, pTemporaryInversion, pMoreQualifications);
    }

    public void addStrategy(String pStrategy, boolean pOnlyIndex, boolean pDistinctOptimization, boolean pTemporaryInversion, boolean pMoreQualifications) {
        this.mExplainData.addStrategy(pStrategy, pOnlyIndex, pDistinctOptimization, pTemporaryInversion, pMoreQualifications);
    }

    public void addTable(String pTable) {
        this.mExplainData.addTable(pTable);
    }

    private String buildMessage(String pText, String pValue, String pCompValue) {
        StringBuffer stb = new StringBuffer(128);
        stb.append(pText);
        stb.append(": ");
        stb.append(pValue);
        stb.append(" (");
        stb.append(pCompValue);
        stb.append(")");
        return stb.toString();
    }

    public void clear() {
        this.getExplainData().clear();
    }

    public Object clone() {
        ExplainObject Obj = new ExplainObject();
        try {
            Obj.setExplainData(this.getExplainData().copy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Obj;
    }

    public boolean equals(Object pObj) {
        this.setEqualsMessage(null);
        if (pObj == null) {
            this.setEqualsMessage("Object is null");
            return false;
        }
        if (this == pObj) {
            return true;
        }
        if (this.getClass() != pObj.getClass()) {
            this.setEqualsMessage("Different class type");
            return false;
        }
        ExplainObject compObj = (ExplainObject)pObj;
        if (this.getExplainData() == compObj.getExplainData()) {
            return true;
        }
        if (this.getExplainData().size() != compObj.getExplainData().size()) {
            this.setEqualsMessage("Different number of table entries");
            return false;
        }
        ExplainDataIterator thisIt = this.iterator();
        ExplainDataIterator compIt = compObj.iterator();
        while (thisIt.hasNext()) {
            thisIt.next();
            compIt.next();
            if (thisIt.getNumberOfItems() != compIt.getNumberOfItems()) {
                this.setEqualsMessage("Different number of strategy items");
                return false;
            }
            if (thisIt.getTable() == null && compIt.getTable() != null) {
                this.setEqualsMessage(this.buildMessage("Different table", thisIt.getTable(), compIt.getTable()));
                return false;
            }
            if (thisIt.getTable() != null && !thisIt.getTable().equalsIgnoreCase(compIt.getTable())) {
                this.setEqualsMessage(this.buildMessage("Different table", thisIt.getTable(), compIt.getTable()));
                return false;
            }
            while (thisIt.hasNextItem()) {
                thisIt.nextItem();
                compIt.nextItem();
                if (thisIt.getStrategy() == null && compIt.getStrategy() != null) {
                    this.setEqualsMessage(this.buildMessage("Different strategy", thisIt.getStrategy(), compIt.getStrategy()));
                    return false;
                }
                if (thisIt.getStrategy() != null && !thisIt.getStrategy().equalsIgnoreCase(compIt.getStrategy())) {
                    this.setEqualsMessage(this.buildMessage("Different strategy", thisIt.getStrategy(), compIt.getStrategy()));
                    return false;
                }
                if (!this.equalsStrategyInfo(thisIt.getStrategyInfo(), compIt.getStrategyInfo())) {
                    return false;
                }
                if (thisIt.getColumn() == null && compIt.getColumn() != null) {
                    this.setEqualsMessage(this.buildMessage("Different column", thisIt.getColumn(), compIt.getColumn()));
                    return false;
                }
                if (thisIt.getColumn() == null || thisIt.getColumn().equalsIgnoreCase(compIt.getColumn())) continue;
                this.setEqualsMessage(this.buildMessage("Different column", thisIt.getColumn(), compIt.getColumn()));
                return false;
            }
        }
        if (this.mExplainData.getResultStatus() != null && compObj.mExplainData.getResultStatus() != null) {
            if (!this.mExplainData.getResultStatus().equalsIgnoreCase(compObj.mExplainData.getResultStatus())) {
                this.setEqualsMessage(this.buildMessage("Different result status", this.mExplainData.getResultStatus(), compObj.mExplainData.getResultStatus()));
                return false;
            }
        } else {
            if (this.mExplainData.getResultStatus() == null && compObj.mExplainData.getResultStatus() != null) {
                this.setEqualsMessage(this.buildMessage("Result status not defined", this.mExplainData.getResultStatus(), compObj.mExplainData.getResultStatus()));
                return false;
            }
            if (this.mExplainData.getResultStatus() != null && compObj.mExplainData.getResultStatus() == null) {
                this.setEqualsMessage(this.buildMessage("Result status not defined", this.mExplainData.getResultStatus(), compObj.mExplainData.getResultStatus()));
                return false;
            }
        }
        return true;
    }

    private boolean equalsStrategyInfo(ArrayList pList, ArrayList pComp) {
        if (pList == null && pComp == null) {
            return true;
        }
        if (pList == null && pComp != null) {
            this.setEqualsMessage("Different number of strategy info entries");
            return false;
        }
        if (pList != null && pComp == null) {
            this.setEqualsMessage("Different number of startegy info entries");
            return false;
        }
        if (pList.size() != pComp.size()) {
            this.setEqualsMessage("Different number of strategy info entries");
            return false;
        }
        ListIterator listIt = pList.listIterator();
        while (listIt.hasNext()) {
            String str = ((String)listIt.next()).trim();
            boolean found = false;
            for (int i = 0; i < pComp.size(); ++i) {
                if (!str.equalsIgnoreCase(((String)pComp.get(i)).trim())) continue;
                pComp.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            this.setEqualsMessage("Strategy info entry " + str + " not found");
            return false;
        }
        if (pComp.size() != 0) {
            this.setEqualsMessage("Different strategy info entries");
            return false;
        }
        return true;
    }

    public String getEqualsMessage() {
        return this.mEqualsMessage;
    }

    public ExplainData getExplainData() {
        return this.mExplainData;
    }

    public ExplainDataIterator iterator() {
        return this.getExplainData().iterator();
    }

    public ExplainDataIteratorPretty iteratorPretty() {
        return this.getExplainData().iteratorPretty();
    }

    private void setEqualsMessage(String newEqualsMessage) {
        this.mEqualsMessage = newEqualsMessage;
    }

    private void setExplainData(ExplainData pData) {
        this.mExplainData = pData;
    }

    public void setResultIsCopied(boolean pBoolean) {
        if (pBoolean) {
            this.mExplainData.setResultStatus("RESULT IS COPIED");
        } else {
            this.mExplainData.setResultStatus("RESULT IS NOT COPIED");
        }
    }
}

