/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ExplainData;
import com.sap.sapdb.testframe.testcase.ExplainDataIterator;
import java.util.ListIterator;

public class ExplainDataIteratorPretty
extends ExplainDataIterator {
    private int[] mColumnWidth;
    private int mRowWidth;
    private String mSeparatorRow;
    private String mHeader;

    ExplainDataIteratorPretty() {
    }

    ExplainDataIteratorPretty(ExplainData pExplainData) {
        super(pExplainData);
        this.mColumnWidth = new int[]{"Table".length(), "Strategy".length(), "Index/Column".length(), "Pagecount".length(), "Strategy information".length()};
        while (super.hasNext()) {
            super.next();
            this.mColumnWidth[0] = Math.max(this.mColumnWidth[0], this.getTable().length());
            while (super.hasNextItem()) {
                super.nextItem();
                if (this.getStrategy() != null && this.getStrategy().length() != 0) {
                    this.mColumnWidth[1] = Math.max(this.mColumnWidth[1], this.getStrategy().length());
                }
                if (this.getPagecount() != null && this.getPagecount().length() != 0) {
                    this.mColumnWidth[2] = Math.max(this.mColumnWidth[2], this.getPagecount().length());
                }
                if (this.getColumn() != null && this.getColumn().length() != 0) {
                    this.mColumnWidth[3] = Math.max(this.mColumnWidth[3], this.getColumn().length());
                }
                if (super.getStrategyInfo() == null || super.getStrategyInfo().size() == 0) continue;
                ListIterator it = super.getStrategyInfo().listIterator();
                while (it.hasNext()) {
                    this.mColumnWidth[4] = Math.max(this.mColumnWidth[4], ((String)it.next()).length());
                }
            }
        }
        this.mRowWidth = 0;
        for (int col = 0; col < this.mColumnWidth.length; ++col) {
            this.mRowWidth += this.mColumnWidth[col];
        }
        StringBuffer SepRow = new StringBuffer(2 * this.mRowWidth);
        for (int col = 0; col < this.mColumnWidth.length; ++col) {
            SepRow.append('+');
            ExplainDataIteratorPretty.appendNChar(SepRow, '-', this.mColumnWidth[col]);
        }
        SepRow.append('+');
        this.mSeparatorRow = SepRow.toString();
        StringBuffer Header = new StringBuffer(2 * this.mRowWidth);
        block12: for (int col = 0; col < this.mColumnWidth.length; ++col) {
            Header.append('|');
            switch (col) {
                case 0: {
                    Header.append("Table");
                    ExplainDataIteratorPretty.appendNSpaces(Header, this.mColumnWidth[col] - "Table".length());
                    continue block12;
                }
                case 1: {
                    Header.append("Strategy");
                    ExplainDataIteratorPretty.appendNSpaces(Header, this.mColumnWidth[col] - "Strategy".length());
                    continue block12;
                }
                case 2: {
                    Header.append("Index/Column");
                    ExplainDataIteratorPretty.appendNSpaces(Header, this.mColumnWidth[col] - "Index/Column".length());
                    continue block12;
                }
                case 3: {
                    Header.append("Pagecount");
                    ExplainDataIteratorPretty.appendNSpaces(Header, this.mColumnWidth[col] - "Pagecount".length());
                    continue block12;
                }
                case 4: {
                    Header.append("Strategy information");
                    ExplainDataIteratorPretty.appendNSpaces(Header, this.mColumnWidth[col] - "Strategy information".length());
                }
            }
        }
        Header.append('|');
        this.mHeader = Header.toString();
        this.mCurrentPosition = 0;
    }

    private void fillColumn(StringBuffer pBody) {
        if (super.getColumn() != null && super.getColumn().length() != 0) {
            pBody.append(super.getColumn());
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[2] - super.getColumn().length());
        } else {
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[2]);
        }
        pBody.append('|');
    }

    private void fillPagecount(StringBuffer pBody) {
        if (super.getPagecount() != null && super.getPagecount().length() != 0) {
            pBody.append(super.getPagecount());
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[3] - super.getPagecount().length());
        } else {
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[3]);
        }
        pBody.append('|');
    }

    private void fillStrategy(StringBuffer pBody) {
        if (super.getStrategy() != null && super.getStrategy().length() != 0) {
            pBody.append(super.getStrategy());
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[1] - super.getStrategy().length());
        } else {
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[1]);
        }
        pBody.append('|');
    }

    private void fillStrategyInfo(StringBuffer pBody) {
        if (super.getStrategyInfo() != null && !super.getStrategyInfo().isEmpty()) {
            ListIterator it = super.getStrategyInfo().listIterator();
            boolean firstLine = true;
            while (it.hasNext()) {
                String str = (String)it.next();
                if (firstLine) {
                    firstLine = false;
                    pBody.append(str);
                    ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[4] - str.length());
                    pBody.append("|\n");
                    continue;
                }
                pBody.append('|');
                ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[0]);
                pBody.append('|');
                ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[1]);
                pBody.append('|');
                ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[2]);
                pBody.append('|');
                ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[3]);
                pBody.append('|');
                pBody.append(str);
                ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[4] - str.length());
                pBody.append("|\n");
            }
        } else {
            ExplainDataIteratorPretty.appendNSpaces(pBody, this.mColumnWidth[4]);
            pBody.append("|\n");
        }
    }

    public Object next() {
        StringBuffer Result = new StringBuffer();
        while (super.hasNext()) {
            super.next();
            StringBuffer Head = new StringBuffer(3 * this.mRowWidth);
            Head.append(this.mSeparatorRow);
            Head.append('\n');
            Head.append(this.mHeader);
            Head.append('\n');
            Head.append(this.mSeparatorRow);
            Head.append('\n');
            StringBuffer Body = new StringBuffer(6 * this.mRowWidth);
            boolean firstLine = true;
            while (super.hasNextItem()) {
                super.nextItem();
                Body.append('|');
                if (firstLine) {
                    Body.append(super.getTable());
                    ExplainDataIteratorPretty.appendNSpaces(Body, this.mColumnWidth[0] - super.getTable().length());
                    firstLine = false;
                } else {
                    ExplainDataIteratorPretty.appendNSpaces(Body, this.mColumnWidth[0]);
                }
                Body.append('|');
                this.fillStrategy(Body);
                this.fillColumn(Body);
                this.fillPagecount(Body);
                this.fillStrategyInfo(Body);
            }
            Result.append(Head);
            Result.append(Body);
        }
        Result.append(this.mSeparatorRow);
        String resultStatus = this.mExplainData.getResultStatus();
        String costValue = this.mExplainData.getCostvalue();
        if (resultStatus != null || costValue != null) {
            Result.append("\n");
            Result.append('|');
            String trailer = resultStatus + ", COSTVALUE = " + costValue;
            Result.append(trailer);
            ExplainDataIteratorPretty.appendNSpaces(Result, this.mSeparatorRow.length() - trailer.length() - 2);
            Result.append("|\n");
            Result.append(this.mSeparatorRow);
        }
        return Result.toString();
    }
}

