/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestSequence
extends ArrayList {
    private static final long serialVersionUID = 24L;
    private String mTestParameterPath = null;
    private String mRestartDatabase = "TRUE";
    private String mRestartDatabaseAfterTest = "FALSE";
    private Properties mParamProperties = null;
    private String mTestSeqName = null;

    public TestSequence() {
    }

    public TestSequence(String pTestParameterPath) {
        this.mTestParameterPath = pTestParameterPath;
    }

    void add(String pClass, String pResponsible, File pParameter) {
        if (pClass == null) {
            return;
        }
        TestSequenceItem item = new TestSequenceItem();
        item.setClass(pClass);
        item.setParameter(pParameter);
        item.setTestDBRestart(this.mRestartDatabase);
        item.setRestartAfterTest(this.mRestartDatabaseAfterTest);
        item.setAdditionalTestParameter(this.mParamProperties);
        if (pResponsible != null) {
            item.setResponsible(pResponsible);
        }
        this.add(item);
    }

    void add(String pClass, String pResponsible, File pArchive, File pParameter) {
        if (pClass == null) {
            return;
        }
        TestSequenceItem item = new TestSequenceItem();
        item.setClass(pClass);
        if (pResponsible != null) {
            item.setResponsible(pResponsible);
        }
        if (pArchive != null) {
            item.setArchive(pArchive);
        }
        if (pParameter != null) {
            item.setParameter(pParameter);
        }
        item.setTestDBRestart(this.mRestartDatabase);
        item.setRestartAfterTest(this.mRestartDatabaseAfterTest);
        item.setAdditionalTestParameter(this.mParamProperties);
        this.add(item);
    }

    void addArchive(String pArchive) throws IOException, FileNotFoundException {
        File Archive = this.constructFile(pArchive);
        ArrayList ArchiveContent = TestSequence.parseArchive(Archive);
        ListIterator it = ArchiveContent.listIterator();
        while (it.hasNext()) {
            String testName = (String)it.next();
            this.add(testName, null, Archive, this.constructParameterFile(testName));
        }
    }

    public void addSequence(String pSequence) throws IOException, FileNotFoundException, SAXNotRecognizedException, SAXNotSupportedException, SAXException {
        this.mTestSeqName = pSequence;
        TestSequenceXML seqXML = new TestSequenceXML();
        seqXML.parse(this.constructFile(pSequence));
    }

    public String getSequenceName() {
        return this.mTestSeqName;
    }

    void addTest(String pClass, String pResponsible) {
        if (pClass == null) {
            return;
        }
        TestSequenceItem item = new TestSequenceItem();
        item.setClass(pClass);
        item.setParameter(this.constructParameterFile(pClass));
        if (pResponsible != null) {
            item.setResponsible(pResponsible);
        }
        item.setTestDBRestart(this.mRestartDatabase);
        item.setRestartAfterTest(this.mRestartDatabaseAfterTest);
        item.setAdditionalTestParameter(this.mParamProperties);
        this.add(item);
    }

    void addTest(String pClass, String pResponsible, String pArchive) throws FileNotFoundException {
        if (pClass == null) {
            return;
        }
        TestSequenceItem item = new TestSequenceItem();
        item.setClass(pClass);
        item.setParameter(this.constructParameterFile(pClass));
        if (pResponsible != null) {
            item.setResponsible(pResponsible);
        }
        if (pArchive != null) {
            item.setArchive(this.constructFile(pArchive));
        }
        item.setTestDBRestart(this.mRestartDatabase);
        item.setRestartAfterTest(this.mRestartDatabaseAfterTest);
        item.setAdditionalTestParameter(this.mParamProperties);
        this.add(item);
    }

    void addTest(String pClass, String pResponsible, String pArchive, String pParameterFile) throws FileNotFoundException {
        if (pClass == null) {
            return;
        }
        TestSequenceItem item = new TestSequenceItem();
        item.setClass(pClass);
        item.setParameter(this.constructParameterFile(pClass, pParameterFile));
        if (pResponsible != null) {
            item.setResponsible(pResponsible);
        }
        if (pArchive != null) {
            item.setArchive(this.constructFile(pArchive));
        }
        item.setTestDBRestart(this.mRestartDatabase);
        item.setRestartAfterTest(this.mRestartDatabaseAfterTest);
        item.setAdditionalTestParameter(this.mParamProperties);
        this.add(item);
    }

    private File constructFile(String pName) throws FileNotFoundException {
        File file1 = new File(pName);
        if (file1.isFile()) {
            return file1;
        }
        File file2 = new File(System.getProperty("user.dir"), pName);
        if (file2.isFile()) {
            return file2;
        }
        throw new FileNotFoundException("File " + pName + " not found");
    }

    private File constructParameterFile(String pTest) {
        String paramPath = this.getTestParameterPath();
        if (paramPath == null) {
            paramPath = System.getProperty("user.dir");
        }
        if (pTest.indexOf(".par") != -1) {
            pTest = pTest.substring(0, pTest.indexOf(".par"));
        }
        if (pTest.indexOf(".") == -1) {
            return new File(paramPath, pTest + ".par");
        }
        String paramName = pTest.substring(pTest.lastIndexOf(".") + 1, pTest.length()) + ".par";
        return new File(paramPath, paramName);
    }

    private File constructParameterFile(String pTest, String pParameter) {
        File file;
        String paramPath = this.getTestParameterPath();
        if (paramPath == null) {
            paramPath = System.getProperty("user.dir");
        }
        if ((file = new File(paramPath, pParameter)).isFile()) {
            return file;
        }
        if (pTest.indexOf(".par") != -1) {
            pTest = pTest.substring(0, pTest.indexOf(".par"));
        }
        if (pTest.indexOf(".") == -1) {
            return new File(paramPath, pParameter);
        }
        String paramName = pTest.substring(pTest.lastIndexOf(".") + 1, pTest.length()) + ".par";
        return new File(paramPath, paramName);
    }

    String getTestParameterPath() {
        return this.mTestParameterPath;
    }

    private static ArrayList parseArchive(File pArchive) throws FileNotFoundException, IOException {
        ArrayList<String> JarItemList = new ArrayList<String>();
        FileInputStream fin = null;
        ZipInputStream jin = null;
        try {
            JarEntry entry;
            fin = new FileInputStream(pArchive);
            jin = new JarInputStream(fin);
            while ((entry = ((JarInputStream)jin).getNextJarEntry()) != null) {
                int pos;
                String str = entry.toString();
                if (str.indexOf("$") != -1 || (pos = str.indexOf("class")) == -1) continue;
                JarItemList.add(str.substring(0, pos - 1).replace('/', '.'));
            }
            ArrayList<String> arrayList = JarItemList;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("File " + pArchive + " not found");
        }
        catch (IOException e) {
            throw new FileNotFoundException("IOError: File " + pArchive);
        }
        finally {
            jin.close();
            fin.close();
        }
    }

    void setTestParameterPath(String newTestParameterPath) {
        this.mTestParameterPath = newTestParameterPath;
    }

    class TestSequenceXML
    extends DefaultHandler {
        static final String E_SEQUENCE = "test-sequence";
        static final String E_TEST = "test";
        static final String E_TEST_NAME = "test-name";
        static final String E_TEST_PARAM_FILE = "test-parameter-file";
        static final String E_TEST_RESPONSIBLE = "test-responsible";
        static final String E_PACKAGE = "package";
        static final String E_PACKAGE_NAME = "package-name";
        static final String E_ARCHIVE = "archive";
        static final String E_ARCHIVE_NAME = "archive-name";
        static final String E_TEST_DB_RESTART = "test-db-restart";
        static final String E_RESTART_AFTER_TEST = "restart-after-test";
        static final String E_TEST_PARAM = "test-parameter";
        static final String E_TEST_PARAM_KEY = "KEY";
        static final String E_TEST_PARAM_VALUE = "VALUE";
        private StringBuffer mContent = null;
        private boolean isArchive = false;
        private boolean isPackage = false;
        private boolean isArchiveWithTest = false;
        private String mArchive = null;
        private String mPackage = null;
        private String mTestName = null;
        private String mTestParameter = null;
        private String mTestResponsible = null;
        private Attributes mAttributes = null;

        TestSequenceXML() {
        }

        public void parse(File pFile) throws IOException, SAXNotRecognizedException, SAXNotSupportedException, SAXException {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            InputSource input = new InputSource(new FileReader(pFile));
            parser.parse(input);
        }

        public void warning(SAXParseException exception) {
            System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }

        public void error(SAXParseException exception) {
            System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
            throw exception;
        }

        public void startDocument() {
            this.mContent = new StringBuffer();
        }

        public void startElement(String pNamespaceURL, String pLocalName, String pQName, Attributes pAttributes) {
            this.mContent.setLength(0);
            if (pLocalName.equals(E_PACKAGE)) {
                this.isPackage = true;
            }
            if (pLocalName.equals(E_ARCHIVE)) {
                this.isArchive = true;
                this.isArchiveWithTest = false;
            }
            if (pLocalName.equalsIgnoreCase(E_RESTART_AFTER_TEST)) {
                TestSequence.this.mRestartDatabaseAfterTest = "TRUE";
            }
            this.mAttributes = pAttributes;
        }

        public void characters(char[] pBuffer, int pStart, int pLength) {
            this.mContent.append(pBuffer, pStart, pLength);
        }

        public void endElement(String pNamespaceURL, String pLocalName, String pQName) {
            if (pLocalName.equals(E_PACKAGE_NAME)) {
                this.mPackage = this.mContent.toString().trim();
            } else if (pLocalName.equals(E_ARCHIVE_NAME)) {
                this.mArchive = this.mContent.toString().trim();
            } else if (pLocalName.equals(E_TEST_NAME)) {
                this.mTestName = this.mContent.toString().trim();
            } else if (pLocalName.equals(E_TEST_PARAM_FILE)) {
                this.mTestParameter = this.mContent.toString().trim();
            } else if (pLocalName.equals(E_TEST_DB_RESTART)) {
                TestSequence.this.mRestartDatabase = this.mContent.toString().trim().toUpperCase();
            } else if (pLocalName.equals(E_TEST_PARAM)) {
                if (TestSequence.this.mParamProperties == null) {
                    TestSequence.this.mParamProperties = new Properties();
                }
                if (this.mAttributes.getValue(E_TEST_PARAM_KEY) != null) {
                    TestSequence.this.mParamProperties.put(this.mAttributes.getValue(E_TEST_PARAM_KEY).trim(), this.mAttributes.getValue(E_TEST_PARAM_VALUE).trim());
                }
            } else if (pLocalName.equals(E_TEST_RESPONSIBLE)) {
                this.mTestResponsible = this.mContent.toString().trim();
            } else if (pLocalName.equals(E_TEST)) {
                if (this.isPackage && this.mPackage != null) {
                    this.mTestName = this.mPackage + "." + this.mTestName;
                }
                if (!this.isArchive && this.mTestParameter == null) {
                    TestSequence.this.addTest(this.mTestName, this.mTestResponsible);
                } else if (this.isArchive && this.mTestParameter == null) {
                    try {
                        TestSequence.this.addTest(this.mTestName, this.mTestResponsible, this.mArchive);
                        this.isArchiveWithTest = true;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File " + this.mArchive + " not found");
                    }
                } else if (!this.isArchive && this.mTestParameter != null) {
                    File param = TestSequence.this.constructParameterFile(this.mTestName, this.mTestParameter);
                    TestSequence.this.add(this.mTestName, this.mTestResponsible, param);
                } else if (this.isArchive && this.mTestParameter != null) {
                    try {
                        File archive = TestSequence.this.constructFile(this.mArchive);
                        File param = TestSequence.this.constructParameterFile(this.mTestName, this.mTestParameter);
                        TestSequence.this.add(this.mTestName, this.mTestResponsible, archive, param);
                        this.isArchiveWithTest = true;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File " + this.mArchive + " not found");
                    }
                }
                this.mTestParameter = null;
                this.mTestResponsible = null;
                TestSequence.this.mParamProperties = null;
                TestSequence.this.mRestartDatabase = "TRUE";
                TestSequence.this.mRestartDatabaseAfterTest = "FALSE";
            } else if (pLocalName.equals(E_PACKAGE)) {
                this.isPackage = false;
                this.mPackage = null;
            } else if (pLocalName.equals(E_ARCHIVE)) {
                if (!this.isArchiveWithTest) {
                    try {
                        TestSequence.this.addArchive(this.mArchive);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File " + this.mArchive + " not found");
                    }
                    catch (IOException e) {
                        System.err.println("Error open file " + this.mArchive);
                    }
                }
                this.isArchive = false;
                this.mArchive = null;
                this.isArchiveWithTest = false;
            }
        }
    }

    public class TestSequenceItem
    extends HashMap {
        private static final long serialVersionUID = 24L;
        static final String CLASS = "Class";
        static final String ARCHIVE = "Archive";
        static final String PARAMETER = "Parameter";
        static final String RESPONSIBLE = "Responsible";
        static final String EXECUTIONTIME = "ExecutionTime";
        static final String ERRORCOUNT = "ErrorCount";
        static final String WARNCOUNT = "WarnCount";
        static final String REMINDERCOUNT = "ReminderCount";
        static final String TESTDBRESTART = "DBRestart";
        static final String TESTPARAM = "TestParameter";
        static final String RESTARTAFTERTEST = "RestartAfterTest";

        TestSequenceItem() {
        }

        public void setClass(String pClass) {
            this.put(CLASS, pClass);
        }

        public void setArchive(File pArchive) {
            this.put(ARCHIVE, pArchive);
        }

        public void setParameter(File pParameter) {
            this.put(PARAMETER, pParameter);
        }

        public void setResponsible(String pResponsible) {
            this.put(RESPONSIBLE, pResponsible);
        }

        public void setTestDBRestart(String pRestart) {
            this.put(TESTDBRESTART, pRestart);
        }

        public void setRestartAfterTest(String pRestartAfterTest) {
            this.put(RESTARTAFTERTEST, pRestartAfterTest);
        }

        public void setAdditionalTestParameter(Properties pParameter) {
            this.put(TESTPARAM, pParameter);
        }

        public String getClassName() {
            return (String)this.get(CLASS);
        }

        public File getArchive() {
            return (File)this.get(ARCHIVE);
        }

        public File getParameter() {
            return (File)this.get(PARAMETER);
        }

        public String getResponsible() {
            return (String)this.get(RESPONSIBLE);
        }

        public String getTestDBRestart() {
            return (String)this.get(TESTDBRESTART);
        }

        public String getRestartAfterTest() {
            return (String)this.get(RESTARTAFTERTEST);
        }

        public Properties getAdditionalTestParameter() {
            return (Properties)this.get(TESTPARAM);
        }

        public void setErrorCount(int pErrorCount) {
            this.put(ERRORCOUNT, new Integer(pErrorCount));
        }

        public void setWarnCount(int pWarnCount) {
            this.put(WARNCOUNT, new Integer(pWarnCount));
        }

        public void setReminderCount(int pReminderCount) {
            this.put(REMINDERCOUNT, new Integer(pReminderCount));
        }

        public void setExecutionTime(int pExecutionTime) {
            this.put(EXECUTIONTIME, new Integer(pExecutionTime));
        }

        public int getErrorCount() {
            Integer Result = (Integer)this.get(ERRORCOUNT);
            if (Result == null) {
                return 0;
            }
            return Result;
        }

        public int getWarnCount() {
            Integer Result = (Integer)this.get(WARNCOUNT);
            if (Result == null) {
                return 0;
            }
            return Result;
        }

        public int getReminderCount() {
            Integer Result = (Integer)this.get(REMINDERCOUNT);
            if (Result == null) {
                return 0;
            }
            return Result;
        }

        public int getExecutionTime() {
            Integer Result = (Integer)this.get(EXECUTIONTIME);
            if (Result == null) {
                return 0;
            }
            return Result;
        }

        public boolean wasExecuted() {
            Integer Result = (Integer)this.get(EXECUTIONTIME);
            return Result != null;
        }
    }
}

