/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.unlocktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestUnlock001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestUnlock001.createWebDAVSchema();
        TestUnlock001.addGlobalMessage((String)("prepare test " + TestUnlock001.getTestClassId()), (char)'I', (String)"lock a file and unlock it afterwards");
        host = new String(TestUnlock001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestUnlock001.getPort();
        baseUrl = TestUnlock001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestUnlock001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestUnlock001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestUnlock001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestUnlock001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestUnlock001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestUnlock001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestUnlock001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource.exists()) {
            locktoken = TestUnlock001.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (!TestUnlock001.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        TestUnlock001.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        try {
            locktoken = TestUnlock001.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            resource.UNLOCK(null, locktoken);
            if (resource.getStatus().getStatusCode() != 204) {
                TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'I', (String)("Test was successful! Status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
        }
        catch (WDVTestJ_WdvException exc) {
            TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'E', (String)("WebDAV says: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
            TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestUnlock001.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock001.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        try {
            if (resource.exists()) {
                TestUnlock001.addGlobalMessage((String)"5. verify that the resource is unlocked by deleting it without using a locktoken", (char)'I', (String)"Deleting...");
                TestUnlock001.doDelete(resource, null, host + ":" + WDV_PORT + baseUrl + urlStr);
            }
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestUnlock001.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

