/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut001.createWebDAVSchema();
        TestPut001.addGlobalMessage((String)("prepare test " + TestPut001.getTestClassId()), (char)'I', (String)"put on a not existing resource");
        host = new String(TestPut001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut001.getPort();
        baseUrl = TestPut001.getParameterString((String)"baseUrl", (String)"webdav");
        var_overwrite = TestPut001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut001.addGlobalMessage((String)"1. DELETE the resource /TestPut001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut001.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPut001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            return;
        }
        TestPut001.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestPut001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut001.addGlobalMessage((String)"4. starting cleaning up - DELETE TestPut001.txt", (char)'E', (String)"Cleaning Up failed due to some Java feature.");
        }
        TestPut001.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

