/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind017
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static NodeList creationdate_nodeList = null;
    static Node creationdate_node = null;
    static String creationdateR = null;

    public static void prepare() throws TestCaseException {
        TestPropfind017.createWebDAVSchema();
        TestPropfind017.addGlobalMessage((String)("prepare test " + TestPropfind017.getTestClassId()), (char)'I', (String)"********************************************************************\n* Do a propfind on the root collection to get the creationdate-tag *\n********************************************************************\n");
        host = new String(TestPropfind017.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind017.getPort();
        baseUrl = TestPropfind017.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind017.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind017.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind017.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind017.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind017.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind017.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\">\n";
        body = body + "   <D:prop>\n";
        body = body + "     <D:creationdate/>";
        body = body + "   </D:prop>\n";
        body = body + "</D:propfind>\n";
        try {
            xmlDocument = resource.PROPFIND(body);
            TestPropfind017.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result is going to be compared to expected data");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPropfind017.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPropfind017.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            exc.printStackTrace();
            return;
        }
        catch (Exception exc) {
            TestPropfind017.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestPropfind017.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
        creationdate_nodeList = xmlDocument.getElementsByTagName("s1:creationdate");
        if (creationdate_nodeList.getLength() == 0) {
            creationdate_nodeList = xmlDocument.getElementsByTagName("D:creationdate");
        }
        if ((creationdate_node = creationdate_nodeList.item(0)) != null && creationdate_node.getFirstChild() != null) {
            creationdateR = creationdate_node.getFirstChild().getNodeValue().toString();
            if (creationdateR.length() <= 0) {
                TestPropfind017.addGlobalMessage((String)"check whether there is a creationdate-node value", (char)'E', (String)("test failed, 'creationdate': " + creationdateR));
                return;
            }
            TestPropfind017.addGlobalMessage((String)"check whether there is a creationdate-node value", (char)'I', (String)("test was succesful, 'creationdate': " + creationdateR));
        } else {
            TestPropfind017.addGlobalMessage((String)"receiving the value of the 'creationdate'-node for the resource", (char)'E', (String)"'creationdate'-node value is not existing");
            try {
                Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            }
            catch (ClassNotFoundException e) {
                this.handleExceptions(e);
            }
            Connection myDBConnection = null;
            try {
                myDBConnection = DriverManager.getConnection("jdbc:sapdb://localhost/WEBDAV", "DBA", "DBA");
            }
            catch (SQLException sqlex) {
                this.handleExceptions(sqlex);
            }
            ResultSet rs = null;
            String query = null;
            query = "select PROPERTY_SHORT_VALUE from \"DBA\".\"WEBDAV_PROPERTY\" where CID = '000000000000000000000000000000000000000000000000' AND (PROPERTY_ID = '000000000000000000000000000000000000000000000005' OR PROPERTY_ID = '000000000000000000000000000000000000000000000010')";
            try {
                Statement stmt = myDBConnection.createStatement();
                rs = stmt.executeQuery(query);
            }
            catch (SQLException sqlex) {
                this.handleExceptions(sqlex);
            }
            try {
                if (rs.first()) {
                    String creationdate = rs.getString("PROPERTY_SHORT_VALUE");
                    rs.next();
                    String lastmodified = rs.getString("PROPERTY_SHORT_VALUE");
                    TestPropfind017.addGlobalMessage((String)"'creationdate' and 'getlastmodified' are saved in the database as following", (char)'I', (String)("creationdate: " + creationdate + "\ngetlastmodifed: " + lastmodified));
                }
            }
            catch (SQLException sqlex) {
                this.handleExceptions(sqlex);
            }
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind017.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestPropfind017.addGlobalMessage((String)"checking the received status code", (char)'I', (String)"207 Multistatus expected");
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

