/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;

public class TestPropfind013
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Vector bodyVector = null;

    public static void prepare() throws TestCaseException {
        TestPropfind013.createWebDAVSchema();
        TestPropfind013.addGlobalMessage((String)("prepare test " + TestPropfind013.getTestClassId()), (char)'I', (String)"create a resource and do several PROPFINDs with a malformed request body");
        host = new String(TestPropfind013.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind013.getPort();
        baseUrl = TestPropfind013.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind013.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind013.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind013.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind013.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind013.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind013.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind013.addGlobalMessage((String)"1. DELETE the resource /TestPropfind013.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind013.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        bodyVector = new Vector();
        String body1 = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body1 = body1 + "\n<D:propfind xmlns:D=\"DAV:\">";
        body1 = body1 + "\n<D:prop>";
        body1 = body1 + "\n<D:lockdiscovery>";
        body1 = body1 + "\n</D:prop>";
        body1 = body1 + "\n</D:propfind>";
        bodyVector.add(body1);
        String body2 = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body2 = body2 + "\n<D:propfind xmlns:D=\"DAV:\">";
        body2 = body2 + "\n<D:prop>";
        body2 = body2 + "\n<D:lockdiscovery/";
        body2 = body2 + "\n</D:prop>";
        body2 = body2 + "\n</D:propfind>";
        bodyVector.add(body2);
        String body3 = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body3 = body3 + "\n<D:propfind xmlns:D=\"DAV:\">";
        body3 = body3 + "\n<D:prop>";
        body3 = body3 + "\n<D:lockdiscovery/>";
        body3 = body3 + "\n<D:prop>";
        body3 = body3 + "\n</D:propfind>";
        bodyVector.add(body3);
    }

    public void run() {
        String actBody = null;
        Enumeration e = bodyVector.elements();
        while (e.hasMoreElements()) {
            try {
                actBody = (String)e.nextElement();
                resource.PROPFIND(actBody);
                TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"check, whether the body was accepted or not.");
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 400) {
                    TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestPropfind013.addGlobalMessage((String)("PROPFIND with body: " + actBody), (char)'I', (String)"server did not accept the malformed request body...test OK.");
                    continue;
                }
                TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestPropfind013.addGlobalMessage((String)("PROPFIND with body: " + actBody), (char)'I', (String)"expected result: '400 Bad Request'");
                exc.printStackTrace();
            }
            catch (Exception exc) {
                if (exc.getMessage().equalsIgnoreCase("400: Bad Request")) {
                    TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)("WebDAV exception: " + exc.getMessage()));
                    TestPropfind013.addGlobalMessage((String)("PROPFIND with body: " + actBody), (char)'I', (String)"server did not accept the malformed request body...test OK.");
                    continue;
                }
                TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
                exc.printStackTrace();
                TestPropfind013.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind013.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind013.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

