/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getcontentlength_node = null;
    static String getcontentlength_Str = null;
    static String getcontentlength_StrR = null;

    public static void prepare() throws TestCaseException {
        TestPropfind007.createWebDAVSchema();
        TestPropfind007.addGlobalMessage((String)("prepare test " + TestPropfind007.getTestClassId()), (char)'I', (String)"create a resource and check whether the property 'getcontentlength_Str' supplied by PROPFIND is correct or not");
        host = new String(TestPropfind007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind007.getPort();
        baseUrl = TestPropfind007.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind007.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind007.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind007.addGlobalMessage((String)"1. DELETE the resource /TestPropfind007.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        block12: {
            String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
            body = body + "<D:propfind xmlns:D=\"DAV:\">";
            body = body + "<D:prop>";
            body = body + "<D:getcontentlength/>";
            body = body + "</D:prop>";
            body = body + "</D:propfind>";
            try {
                xmlDocument = resource.PROPFIND(body);
                TestPropfind007.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result is going to be compared to posted data");
                xmlDocument.toString();
            }
            catch (WDVTestJ_WdvException exc) {
                TestPropfind007.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestPropfind007.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
                exc.printStackTrace();
            }
            catch (Exception exc) {
                TestPropfind007.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
                exc.printStackTrace();
                TestPropfind007.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
            }
            try {
                NodeList nl = xmlDocument.getElementsByTagName("s1:getcontentlength");
                if (nl.getLength() == 0) {
                    nl = xmlDocument.getElementsByTagName("D:getcontentlength");
                }
                getcontentlength_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestPropfind007.addGlobalMessage((String)"retrieving the 'getcontentlength'-element", (char)'E', (String)"the 'getcontentlength'-element for the reource could not be retrieved");
            }
            String status = null;
            status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
            if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
                try {
                    getcontentlength_StrR = getcontentlength_node.getFirstChild().getNodeValue().toString();
                    getcontentlength_Str = new Integer(content.length()).toString();
                    if (getcontentlength_StrR.compareToIgnoreCase(getcontentlength_Str) == 0) {
                        TestPropfind007.addGlobalMessage((String)"comparing the posted and the received getcontentlength-value", (char)'I', (String)"test succesful");
                        break block12;
                    }
                    TestPropfind007.addGlobalMessage((String)"comparing the posted and the received getcontentlength-value", (char)'E', (String)"test failed");
                    TestPropfind007.addGlobalMessage((String)"comparing the posted and the received getcontentlength-value", (char)'I', (String)("posted: " + getcontentlength_Str));
                    TestPropfind007.addGlobalMessage((String)"comparing the posted and the received getcontentlength-value", (char)'I', (String)("received: " + getcontentlength_StrR));
                }
                catch (NullPointerException npexc) {
                    TestPropfind007.addGlobalMessage((String)"receiving the value of the 'getcontentlength'-node for the resource", (char)'E', (String)"value of 'getcontentlength'-node is not existing");
                }
            } else {
                TestPropfind007.addGlobalMessage((String)"receiving 'getcontentlength'-node for the resource", (char)'E', (String)"'getcontentlength'-node is not existing");
                TestPropfind007.addGlobalMessage((String)"receiving 'getcontentlength'-node for the resource", (char)'I', (String)("status code: " + status));
            }
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind007.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestPropfind007.addGlobalMessage((String)"checking the received status code", (char)'I', (String)"207 Multistatus expected");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind007.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind007.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind007.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPropfind007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

