/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static NodeList propstat_nodeList = null;
    static Node propstat_node = null;
    static String creationdate = null;
    static String creationdateR = null;

    public static void prepare() throws TestCaseException {
        TestPropfind005.createWebDAVSchema();
        TestPropfind005.addGlobalMessage((String)("prepare test " + TestPropfind005.getTestClassId()), (char)'I', (String)"create a resource and check whether the data supplied by PROPFIND is correct or not");
        host = new String(TestPropfind005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind005.getPort();
        baseUrl = TestPropfind005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind005.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind005.addGlobalMessage((String)"1. DELETE the resource /TestPropfind005.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestPropfind005.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        SimpleDateFormat sdf_fulldate = new SimpleDateFormat("EEE, dd MMM yyyy", new Locale("en"));
        SimpleDateFormat sdf_fulltime = new SimpleDateFormat("HH:mm:ss z", new Locale("en"));
        if (TestPropfind005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            sdf_fulltime.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        Date date = new Date();
        creationdate = sdf_fulldate.format(date) + " " + sdf_fulltime.format(date);
    }

    public void run() {
        Node creationdate_node;
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\">\n";
        body = body + "   <D:prop>\n";
        body = body + "      <D:creationdate/>\n";
        body = body + "   </D:prop>\n";
        body = body + "</D:propfind>\n";
        try {
            xmlDocument = resource.PROPFIND(body);
            TestPropfind005.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result is going to be compared to posted data");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPropfind005.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPropfind005.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            exc.printStackTrace();
        }
        catch (Exception exc) {
            TestPropfind005.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestPropfind005.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
        }
        xmlDocument.toString();
        NodeList creationdate_nodeList = xmlDocument.getElementsByTagName("s1:creationdate");
        if (creationdate_nodeList.getLength() == 0) {
            creationdate_nodeList = xmlDocument.getElementsByTagName("D:creationdate");
        }
        if ((creationdate_node = creationdate_nodeList.item(0)) != null && creationdate_node.getFirstChild() != null) {
            creationdateR = creationdate_node.getFirstChild().getNodeValue().toString();
            if (creationdateR.substring(0, 16).compareToIgnoreCase(creationdate.substring(0, 16)) == 0) {
                TestPropfind005.addGlobalMessage((String)"comparing the posted and the received creationdate-value", (char)'I', (String)"test succesful");
            } else {
                if (!TestPropfind005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                    TestPropfind005.addGlobalMessage((String)"comparing the posted and the received creationdate-value", (char)'W', (String)"test failed see PTS-message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128786");
                } else {
                    TestPropfind005.addGlobalMessage((String)"comparing the posted and the received creationdate-value", (char)'E', (String)"test failed");
                }
                TestPropfind005.addGlobalMessage((String)"comparing the posted and the received creationdate-value", (char)'I', (String)("posted: " + creationdate));
                TestPropfind005.addGlobalMessage((String)"comparing the posted and the received creationdate-value", (char)'I', (String)("received: " + creationdateR));
            }
        } else {
            TestPropfind005.addGlobalMessage((String)"receiving the value of the 'creationdate'-node for the resource", (char)'E', (String)"'creationdate'-node is not existing");
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind005.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestPropfind005.addGlobalMessage((String)"checking the received status code", (char)'I', (String)"207 Multistatus expected");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind005.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind005.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPropfind005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

