/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove008
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String dest_Url = null;

    public static void prepare() throws TestCaseException {
        TestMove008.createWebDAVSchema();
        TestMove008.addGlobalMessage((String)("prepare test " + TestMove008.getTestClassId()), (char)'I', (String)"*************************************************************************************\n* Copy a resource to existing collection and Move it afterwards to same destination *\n*************************************************************************************");
        host = new String(TestMove008.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove008.getPort();
        baseUrl = TestMove008.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove008.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove008.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove008.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove008.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove008.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove008.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"1. DELETE /tempMove008 and /TestMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"1. DELETE /tempMove008 and /TestMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"2. create the folder /TestMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove008.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"2. create the folder /tempMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove008.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove008/TestMove008.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"3. create the resource /tempMove008/TestMove008.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "In der abendlichen Sonne sitzen wir gebeugten R\u00fcckens auf den B\u00e4nken in dem Gr\u00fcnen. Unsere Arme h\u00e4ngen nieder, unsere Augen blinzeln traurig.";
        contentType = "text/plain";
        TestMove008.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove008/TestMove008.txt").toString();
        }
        catch (MalformedURLException exc) {
            exc.printStackTrace();
            TestMove008.addGlobalMessage((String)"Creating the destination URL", (char)'E', (String)"An Exception occured during the creation of the destination URL");
        }
        String body = null;
        TestMove008.doCopy(resource, dest_Url, var_overwrite, body, locktoken, null);
    }

    public void run() {
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove008/TestMove008.txt").toString();
        }
        catch (MalformedURLException exc) {
            exc.printStackTrace();
            TestMove008.addGlobalMessage((String)"Creating the destination URL", (char)'E', (String)"An Exception occured during the creation of the destination URL");
        }
        String body = null;
        TestMove008.doMove(resource, dest_Url, var_overwrite, body, locktoken, "infinity");
        if (var_overwrite == "T") {
            try {
                String contentR = new String(resource.GET());
                if (contentR != null) {
                    TestMove008.addGlobalMessage((String)"Check (source deleted)", (char)'E', (String)"...failed. There is still data in the source directory.");
                }
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 404) {
                    TestMove008.addGlobalMessage((String)"Test (source deleted)", (char)'I', (String)"...OK");
                }
            }
            catch (IOException exc) {
                this.handleExceptions(exc);
            }
            urlStr = "/TestMove008/TestMove008.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove008.addGlobalMessage((String)"check if the destination resource has the correct content data", (char)'E', (String)"Test failed due to some Java feature");
            }
            TestMove008.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (var_overwrite == "F") {
            urlStr = "/tempMove008/TestMove008.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove008.addGlobalMessage((String)"compare the new content and the new source resource", (char)'E', (String)"Preparations failed due to some Java feature");
            }
            TestMove008.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
            urlStr = "/TestMove008/TestMove008.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove008.addGlobalMessage((String)"check if the destination resource still exists", (char)'E', (String)"Test failed due to some Java feature");
            }
            TestMove008.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"7. clean up and DELETE /tempMove008 and /TestMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove008.addGlobalMessage((String)"7. clean up and DELETE /tempMove008 and /TestMove008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

