/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove007
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;
    static long sleep_time = 5000L;
    static boolean TEST_WAS_OK = true;

    public static void prepare() throws TestCaseException {
        TestMove007.createWebDAVSchema();
        TestMove007.addGlobalMessage((String)("prepare test " + TestMove007.getTestClassId()), (char)'I', (String)"*********************************************************\n* Move a collection with subfolders and resources using *\n* 'depth header = infintiy' explicitly                  *\n*********************************************************");
        host = new String(TestMove007.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove007.getPort();
        baseUrl = TestMove007.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove007.getParameterString((String)"var_overwrite", (String)"F");
        depth = "infinity";
        start_server = TestMove007.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove007.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove007.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove007.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove007.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"1. DELETE /tempMove007 and /TestMove007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"1. DELETE /tempMove007 and /TestMove007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"2. create the folder /TestMove007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove007.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"2. create the folder /tempMove007 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove007.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Locken braun, lehnt es am Elektrozaun. Wenn es mit den Augen rollt, will es sagen: Zu viel Volt!";
        contentType = "text/plain";
        for (int a = 1; a <= 3; ++a) {
            urlStr = new String("/tempMove007/folder007_a_" + a);
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove007.addGlobalMessage((String)("3. create sub-folder /folder007_a_" + a + " at /tempMove007"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            TestMove007.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
            urlStr = new String("/tempMove007/folder007_a_" + a + "/res007_" + a + ".txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove007.addGlobalMessage((String)("4. create the resource /tempMove007/folder007_a_" + a + "/res007_" + a + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            if (!TestMove007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
                return;
            }
            for (int b = 1; b <= 3; ++b) {
                urlStr = new String("/tempMove007/folder007_a_" + a + "/folder007_b_" + b);
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestMove007.addGlobalMessage((String)("3. create sub-folder /folder007_b_" + b + " at /tempMove007/folder007_a_" + a), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                TestMove007.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
                urlStr = new String("/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/res007_" + b + ".txt");
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestMove007.addGlobalMessage((String)("4. create the resource /tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/res007_" + b + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                if (!TestMove007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
                    return;
                }
                for (int c = 1; c <= 3; ++c) {
                    urlStr = new String("/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/folder007_c_" + c);
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestMove007.addGlobalMessage((String)("3. create sub-folder /folder007_c_" + c + " at /tempMove007/folder007_a_" + a + "/folder007_b_" + b), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    TestMove007.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
                    urlStr = new String("/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/folder007_c_" + c + "/res007_" + c + ".txt");
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestMove007.addGlobalMessage((String)("4. create the resource /tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/folder007_c_" + c + "/res007_" + c + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    if (TestMove007.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) continue;
                    return;
                }
            }
        }
    }

    public void run() {
        urlStr = new String("/tempMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"5. MOVE the collection /tempMove007 to /TestMove007 with depth = infinity", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove007/tempMove007").toString();
            String body = null;
            locktoken = null;
            TestMove007.doMove(resource, dest_Url, var_overwrite, body, locktoken, depth);
        }
        catch (MalformedURLException exc) {
            TestMove007.addGlobalMessage((String)"5. MOVE the collection /tempMove007 to /TestMove007 with depth = infinity", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        for (int a = 1; a <= 3 && TEST_WAS_OK; ++a) {
            urlStr = new String("/TestMove007/tempMove007/folder007_a_" + a + "/res007_" + a + ".txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove007.addGlobalMessage((String)("6. check for /TestMove007/tempMove007/folder007_a_" + a + "/res007_" + a + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            TEST_WAS_OK = TestMove007.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
            for (int b = 1; b <= 3 && TEST_WAS_OK; ++b) {
                urlStr = new String("/TestMove007/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/res007_" + b + ".txt");
                resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                if (resource == null) {
                    TestMove007.addGlobalMessage((String)("6. /TestMove007/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/res007_" + b + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                }
                TEST_WAS_OK = TestMove007.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
                for (int c = 1; c <= 3 && TEST_WAS_OK; ++c) {
                    urlStr = new String("/TestMove007/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/folder007_c_" + c + "/res007_" + c + ".txt");
                    resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
                    if (resource == null) {
                        TestMove007.addGlobalMessage((String)("6. /TestMove007/tempMove007/folder007_a_" + a + "/folder007_b_" + b + "/folder007_c_" + c + "/res007_" + c + ".txt"), (char)'E', (String)"Preparations failed due to some Java feature.");
                    }
                    TEST_WAS_OK = TestMove007.compareContent(resource, content, contentType, content.length(), host + ":" + WDV_PORT + baseUrl + urlStr);
                }
            }
        }
        if (!TEST_WAS_OK) {
            return;
        }
        urlStr = new String("/tempMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"7. check, if the source has been deleted", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            if (resource.GET() != null) {
                TestMove007.addGlobalMessage((String)"7. check, if the source has been deleted", (char)'E', (String)"source has not been deleted.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestMove007.addGlobalMessage((String)"7. check, if the source has been deleted", (char)'I', (String)"Test succesful!");
            } else {
                TestMove007.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestMove007.addGlobalMessage((String)"GET failed due to some WebDAV feature", (char)'E', (String)"Expected result: 404 Not Found");
            }
        }
        catch (Exception exc) {
            TestMove007.addGlobalMessage((String)("GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestMove007.addGlobalMessage((String)"Test failed due to some Java feature", (char)'E', (String)("Skipping test " + TestMove007.getTestClassId()));
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (!TEST_WAS_OK) {
            return;
        }
        urlStr = new String("/TestMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove007");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove007.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove007.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

