/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock023
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock023.createWebDAVSchema();
        TestLock023.addGlobalMessage((String)("prepare test " + TestLock023.getTestClassId()), (char)'I', (String)"lock a file and try to do a put on it without a locktoken");
        host = new String(TestLock023.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock023.getPort();
        baseUrl = TestLock023.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock023.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock023.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock023.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock023.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock023.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock023.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock023.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock023.addGlobalMessage((String)"1. DELETE resource /TestLock023.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && !TestLock023.doDelete(resource, locktoken = TestLock023.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr), host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestLock023.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = "";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() != 400) {
                TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'E', (String)("Server returned 'Status " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'I', (String)"Server should return 'Status 400 Bad Request' Test was NOT successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 400) {
                TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'I', (String)"Server returned 'Status 400 Bad Request', Test was successful!");
            } else {
                TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'I', (String)"Expected: '400 Bad RequestTest', Test failed due to some WebDAV feature.");
            }
        }
        catch (Exception exc) {
            TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock023.addGlobalMessage((String)"3. LOCK the resource /TestLock023.txt", (char)'I', (String)"Test failed due to some Java feature.");
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock023.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock023.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

