/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock017
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock017.createWebDAVSchema();
        TestLock017.addGlobalMessage((String)("prepare test " + TestLock017.getTestClassId()), (char)'I', (String)"a collection that includes a locked resource somewhere in a sub-directory shall be deleted");
        host = new String(TestLock017.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock017.getPort();
        baseUrl = TestLock017.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock017.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock017.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock017.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock017.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock017.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock017.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock017/test/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"7. DELETE all resources to clean up the test", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock017.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock017.doUnlock(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists()) {
            locktoken = TestLock017.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock017"))) == null) {
            TestLock017.addGlobalMessage((String)"1. DELETE /TestLock017 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestLock017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock017");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"1. create the collection /TestLock017 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestLock017.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock017/test");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"2. create the collection /TestLock017/test at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestLock017.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock017/test.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"3. create the file /TestLock017/test.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestLock017.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock017/test/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"4. create the file /TestLock017/test/locked.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestLock017.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        TestLock017.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/TestLock017");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        try {
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() != 207) {
                TestLock017.addGlobalMessage((String)"6. The DELETE method must evoke a 207 Multi Status response", (char)'W', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "expected: 207 Multi Status...Test failed due to some WebDAV feature.\n" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1126293"));
                return;
            }
            TestLock017.addGlobalMessage((String)"Test has to be completed.", (char)'I', (String)"More functionality of this test is to be implemented as the WebDAV server responses with Status Code '207");
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock017.addGlobalMessage((String)"6. The DELETE method must evoke a 207 Multi Status response", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock017.addGlobalMessage((String)"6. The DELETE method must evoke a 207 Multi Status response", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock017.addGlobalMessage((String)"6. The DELETE method must evoke a 207 Multi Status response", (char)'E', (String)("Java exception: " + exc));
            TestLock017.addGlobalMessage((String)"6. The DELETE method must evoke a 207 Multi Status response", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestLock017/test/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock017.addGlobalMessage((String)"7. DELETE all resources to clean up the test", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock017.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock017"))) == null) {
            TestLock017.addGlobalMessage((String)"7. DELETE all resources to clean up the test", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock017.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock017.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

