/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock004.createWebDAVSchema();
        TestLock004.addGlobalMessage((String)("prepare test " + TestLock004.getTestClassId()), (char)'I', (String)"lock a resource and do a put on it with a wrong locktoken and try to PUT another resource afterwards");
        host = new String(TestLock004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock004.getPort();
        baseUrl = TestLock004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock004.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock004.addGlobalMessage((String)"1. DELETE resource /TestLock004.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
            return;
        }
        if (resource.exists()) {
            locktoken = TestLock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestLock004.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>D041249</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock004.addGlobalMessage((String)"3. LOCK the resource /TestLock004.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock004.addGlobalMessage((String)"3. LOCK the resource /TestLock004.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestLock004.addGlobalMessage((String)"3. LOCK the resource /TestLock004.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock004.addGlobalMessage((String)"3. LOCK the resource /TestLock004.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        try {
            if (resource.exists()) {
                locktoken = TestLock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr).substring(0, 10);
            }
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 423) {
                TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + "expected: 423 Locked"));
                TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 423) {
                TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'I', (String)"Test was successful (PUT not possible).");
            }
            TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock004.addGlobalMessage((String)"4. PUT the file TestLock004.txt again with a wrong locktoken", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
        urlStr = new String("/anotherPut.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock004.addGlobalMessage((String)"5. PUT another resource /anotherPut.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
            return;
        }
        locktoken = null;
        TestLock004.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock004.txt"))) == null) {
            TestLock004.addGlobalMessage((String)"6. DELETE /anotherPut.txt and /TestLock004.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
            return;
        }
        if (resource.exists()) {
            locktoken = TestLock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

