/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.headtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestHead001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestHead001.createWebDAVSchema();
        TestHead001.addGlobalMessage((String)("prepare test " + TestHead001.getTestClassId()), (char)'I', (String)"head on an existing resource");
        host = new String(TestHead001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestHead001.getPort();
        baseUrl = TestHead001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestHead001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestHead001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestHead001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestHead001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestHead001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestHead001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestHead001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestHead001.addGlobalMessage((String)"1. DELETE resource /TestHead001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestHead001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestHead001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        long contentLengthR;
        String contentTypeR;
        String contentR = null;
        try {
            contentR = new String(resource.HEAD(null));
        }
        catch (WDVTestJ_WdvException exc) {
            TestHead001.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)"Test failed.");
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        if (contentR != null && contentR.compareTo("") != 0) {
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Content recieved. Content: " + contentR));
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        if ((contentTypeR = resource.getResponseHeaders().contentType()).compareTo(contentType) != 0) {
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Recieved content type (" + contentTypeR + ") not equal to posted content type (" + contentType + ")"));
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        if ((contentLengthR = resource.getResponseHeaders().contentLength()) != contentLength) {
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Recieved content length (" + contentLengthR + ") not equal to posted content length (" + contentLength + ")"));
            TestHead001.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestHead001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestHead001.addGlobalMessage((String)"4. clean up and DELETE resource /TestHead001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestHead001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

