/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static int contentLength = 0;
    static String expectedContent = "";
    static String locktoken = null;
    static String contentRange = null;
    static Byte firstByte = null;
    static Byte lastByte = null;

    public static void prepare() throws TestCaseException {
        TestGet011.createWebDAVSchema();
        TestGet011.addGlobalMessage((String)("prepare test " + TestGet011.getTestClassId()), (char)'I', (String)"*********************************************************************\n* get on an existing file and try to receive a byte range whose end *\n* byte position exceeds the content length (Status 206)        \t *\n*********************************************************************");
        host = new String(TestGet011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet011.getPort();
        baseUrl = TestGet011.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet011.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet011.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet011.addGlobalMessage((String)"1. DELETE /TestGet011.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet011.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        expectedContent = content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        contentLength = content.length();
        contentType = "text/plain";
        if (!TestGet011.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        contentRange = "bytes=0-" + contentLength + 100;
        try {
            String receivedContent = new String(resource.GET(contentRange));
            if (TestGet011.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                if (resource.getStatus().getStatusCode() == 206) {
                    if (receivedContent.equals(expectedContent)) {
                        TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("Status Code is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'" + "and the received content equals the expected content."));
                    } else {
                        TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The received content DOES NOT equal the expected content.\nexpected: " + expectedContent + " (content length: " + expectedContent.length() + ")\n" + "received: " + receivedContent + " (content length: " + receivedContent.length() + ")"));
                    }
                } else {
                    TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The HTTP status in the response DOES NOT equal the expected one\nexpected: HTTP/1.1 206 Partial content\nreceived: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                }
            } else {
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)"Returned 206 instead of 416");
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestGet011.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
            } else if (exc.getStatusCode() == 416) {
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("Status Code is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'"));
            } else {
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + ". Expected 416 Range not satisfieable"));
                TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (Exception exc) {
            TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet011.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet011.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

