/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.deletetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDelete001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestDelete001.createWebDAVSchema();
        TestDelete001.addGlobalMessage((String)("prepare test " + TestDelete001.getTestClassId()), (char)'I', (String)"delete an existing resource");
        host = new String(TestDelete001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDelete001.getPort();
        baseUrl = TestDelete001.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDelete001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDelete001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDelete001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDelete001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDelete001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDelete001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDelete001.addGlobalMessage((String)"1. PUT resource /TestDelete001.txt to baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestDelete001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was succesful.");
            } else {
                TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 204 No Content"));
                TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 204 No Content"));
            TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestDelete001.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestDelete001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

