/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy008
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestCopy008.createWebDAVSchema();
        TestCopy008.addGlobalMessage((String)("prepare test " + TestCopy008.getTestClassId()), (char)'I', (String)"copy an existing resource on an existing collection (with overwrite ='T')");
        host = new String(TestCopy008.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy008.getPort();
        baseUrl = TestCopy008.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy008.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy008.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy008.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy008.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy008.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy008.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"1. DELETE /TestCopy008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy008.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"1. DELETE /TestCopy008.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"2. create the folder /TestCopy008 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy008.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy008.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"2. create resource /TestCopy008.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy008.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String dir_contentType;
        urlStr = new String("/TestCopy008.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"3. COPY /TestCopy008.txt on /TestCopy008", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String dest_Url = null;
        String body = null;
        locktoken = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy008").toString();
        }
        catch (MalformedURLException exc) {
            TestCopy008.addGlobalMessage((String)"3. COPY /TestCopy008.txt on /TestCopy008", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestCopy008.addGlobalMessage((String)"3. COPY /TestCopy008.txt on /TestCopy008", (char)'I', (String)("server returned the correct status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\nTest was successful!"));
            } else {
                TestCopy008.addGlobalMessage((String)"3. COPY /TestCopy008.txt on /TestCopy008", (char)'E', (String)("unexpected status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy008.addGlobalMessage((String)"3. COPY /TestCopy008.txt on /TestCopy008", (char)'I', (String)"expected: 204 No Content");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestCopy008.addGlobalMessage((String)("COPY TO http://" + dest_Url), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestCopy008.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
        }
        catch (Exception exc) {
            TestCopy008.addGlobalMessage((String)("COPY TO http://" + dest_Url), (char)'E', (String)("Java exception: " + exc));
            TestCopy008.addGlobalMessage((String)"COPY failed due to some Java feature", (char)'I', (String)("Skipping test " + TestCopy008.getTestClassId()));
        }
        urlStr = new String("/TestCopy008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"3. compare the source and the destination", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if ((dir_contentType = TestCopy008.doPropfindByTagName(resource, "getcontenttype", host + ":" + WDV_PORT + baseUrl + urlStr)).equalsIgnoreCase("text/plain")) {
            TestCopy008.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Recieved content type equals expected content type\nTest was successful.");
        } else {
            TestCopy008.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Recieved content type (" + dir_contentType + ") not equal to expected content type (\"text/plain\")"));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy008");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"4. clean up and DELETE /TestCopy008 as well as /TestCopy008.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy008.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy008.addGlobalMessage((String)"4. clean up and DELETE /TestCopy008 as well as /TestCopy008.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy008.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

