/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests;

import com.sap.sapdb.WebDAVTest.jtests.PExec;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WDVTestJ_WebDAVTestHelper
extends TestCase {
    public static String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static boolean OS_IS_WINDOWS;
    public static String FS;
    public static int OS_ARCHITECTURE;
    public static String pgmPath;
    public static String LOG_DIR;
    public static int WDV_VERSION;
    public static int WDV_VERSION_SHORT;
    public static int WDV_PORT;
    public static int WDV_STARTUP_TIME;
    public static boolean start_server;

    public WDVTestJ_WebDAVTestHelper() throws SQLException, TestDatabaseException {
        OS_ARCHITECTURE = ((TestDatabaseSap)WDVTestJ_WebDAVTestHelper.getDatabase()).getBitVersion();
    }

    public void run() {
    }

    private static boolean isWindows() {
        return OS_NAME.indexOf("windows") > -1;
    }

    protected static int getVersionId() {
        String kernelVersion = "4711";
        int versionId = 47114711;
        try {
            kernelVersion = ((TestDatabaseSap)WDVTestJ_WebDAVTestHelper.getDatabase()).getKernelVersion();
        }
        catch (TestDatabaseException tdbex) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)((Object)tdbex));
        }
        if (kernelVersion.indexOf("7.4.3") > -1 || kernelVersion.indexOf("7.4.03") > -1) {
            versionId = 74;
        }
        if (kernelVersion.indexOf("7.5.0") > -1 || kernelVersion.indexOf("7.5.00") > -1) {
            versionId = 75;
        }
        if (kernelVersion.indexOf("7.5.1") > -1 || kernelVersion.indexOf("7.5.01") > -1) {
            versionId = 75;
        }
        if (kernelVersion.indexOf("7.6.0") > -1 || kernelVersion.indexOf("7.6.00") > -1) {
            versionId = 76;
        }
        return versionId;
    }

    public static int getPort() {
        OS_IS_WINDOWS = WDVTestJ_WebDAVTestHelper.isWindows();
        WDV_VERSION = WDVTestJ_WebDAVTestHelper.getVersionId();
        WDV_VERSION_SHORT = new Integer(new Integer(WDV_VERSION).toString().substring(0, 2));
        String tomcat_port = System.getProperty("env.TOMCAT_PORT");
        if (tomcat_port != null && !tomcat_port.equals("")) {
            try {
                int tomcat_port_int = Integer.parseInt(tomcat_port);
                System.out.println("Valid TOMCAT_PORT found. Overwrite parameter file provided port with " + tomcat_port_int);
                return tomcat_port_int;
            }
            catch (NumberFormatException e) {
                System.out.println("No valid TOMCAT_PORT found. Use the parameter file provided port " + tomcat_port);
            }
        }
        if (OS_IS_WINDOWS) {
            return WDVTestJ_WebDAVTestHelper.getParameterInt((String)"port", (int)85);
        }
        return 50000 + WDV_VERSION;
    }

    public static String getBasicAuthUser() {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            return WDVTestJ_WebDAVTestHelper.getParameterString((String)"basic_auth_user", (String)"");
        }
        return null;
    }

    public static String getBasicAuthPwd() {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            return WDVTestJ_WebDAVTestHelper.getParameterString((String)"basic_auth_pwd", (String)"");
        }
        return null;
    }

    protected String getLogFileDir() {
        String log_dir = null;
        if (OS_IS_WINDOWS) {
            File myTempRegFile = new File("c:" + FS + "WaTempLogFile.reg");
            PrintWriter pw = new PrintWriter(System.out);
            String[] cmdarray = new String[]{"regedit.exe", "/e", myTempRegFile.toString(), "\"HKEY_LOCAL_MACHINE\\SOFTWARE\\SAP\\SAP DBTech\\WebAgent" + WDVTestJ_WebDAVTestHelper.getVersionId() + "\\Global\""};
            PExec p = new PExec(cmdarray, null, new File("c:" + FS), pw);
            p.exec();
            FileInputStream myFileInputStream = null;
            try {
                myFileInputStream = new FileInputStream(myTempRegFile);
            }
            catch (FileNotFoundException fnf) {
                this.handleExceptions(fnf);
            }
            Charset myCharset = Charset.forName("UTF-16LE");
            InputStreamReader myInputStreamReader = new InputStreamReader((InputStream)myFileInputStream, myCharset);
            char[] cachedContent = new char[(int)myTempRegFile.length()];
            int i = (int)myTempRegFile.length();
            if (i != 0) {
                try {
                    do {
                        myInputStreamReader.read(cachedContent, 0, i);
                    } while (myInputStreamReader.read() != -1);
                }
                catch (IOException ioex) {
                    this.handleExceptions(ioex);
                }
            }
            String myRegFileContent = new String(cachedContent);
            String startPattern = "\"LogFile\"=\"";
            String endPattern = "wa.log\"";
            int startIndex = myRegFileContent.indexOf(startPattern) + startPattern.length();
            int endIndex = myRegFileContent.indexOf(endPattern, startIndex);
            log_dir = myRegFileContent.substring(startIndex, endIndex);
        } else {
            log_dir = LOG_DIR;
        }
        return log_dir;
    }

    public static void startWebDAV(int port) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
            if (OS_IS_WINDOWS) {
                BufferedReader brInput = null;
                BufferedReader brError = null;
                String input = null;
                String error = null;
                String cmd = null;
                File myTempRegFile = new File("c:" + FS + "WaTemp.reg");
                try {
                    myTempRegFile.createNewFile();
                }
                catch (IOException ioex) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)ioex);
                }
                Runtime run = Runtime.getRuntime();
                String[] cmdarray = new String[]{"regedit.exe", "/e", myTempRegFile.toString(), "\"HKEY_LOCAL_MACHINE\\SOFTWARE\\SAP\\SAP DBTech\\WebAgent" + new Integer(WDV_VERSION).toString().substring(0, 2) + "\\Services\\webdav\""};
                String cmdToCall = "";
                for (int i = 0; i < cmdarray.length; ++i) {
                    cmdToCall = cmdToCall + cmdarray[i] + " ";
                }
                Process p = null;
                try {
                    p = run.exec(cmdarray);
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                try {
                    Thread.sleep(WDV_STARTUP_TIME);
                }
                catch (InterruptedException e1) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e1);
                }
                FileInputStream myFileInputStream = null;
                try {
                    myFileInputStream = new FileInputStream(myTempRegFile);
                }
                catch (FileNotFoundException fnf) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"read the temporary .reg file and get the program path of the 'wahttp' server", (char)'E', (String)("the file could not be found in " + myTempRegFile.toString() + " Test will be canceled."));
                    return;
                }
                Charset myCharset = Charset.forName("UTF-16LE");
                InputStreamReader myInputStreamReader = new InputStreamReader((InputStream)myFileInputStream, myCharset);
                char[] cachedContent = new char[(int)myTempRegFile.length()];
                int i = (int)myTempRegFile.length();
                if (i != 0) {
                    try {
                        do {
                            myInputStreamReader.read(cachedContent, 0, i);
                        } while (myInputStreamReader.read() != -1);
                    }
                    catch (IOException ioex) {
                        WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)ioex);
                        return;
                    }
                }
                String myRegFileContent = new String(cachedContent);
                try {
                    String startPattern = "\"Library\"=\"";
                    String endPattern = "wdvhandler.dll\"";
                    int startIndex = myRegFileContent.indexOf(startPattern) + startPattern.length();
                    int endIndex = myRegFileContent.indexOf(endPattern, startIndex);
                    pgmPath = myRegFileContent.substring(startIndex, endIndex);
                }
                catch (StringIndexOutOfBoundsException sioe) {
                    System.out.println("try to read the program directry in \n" + myRegFileContent);
                    sioe.printStackTrace();
                }
                cmd = "cmd  /c net stop \"SAP DB WWW\"";
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Stopping the \"old\" wahttp service with the following command: ", (char)'I', (String)cmd);
                try {
                    p = run.exec(cmd, null, new File(pgmPath));
                    p.waitFor();
                    brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    input = brInput.readLine();
                    while (brInput.ready()) {
                        input = input + "\n" + brInput.readLine();
                    }
                    if (input != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'T', (String)("InputStream of '" + cmd + "': \n" + input));
                    }
                    error = brError.readLine();
                    while (brError.ready()) {
                        error = error + "\n" + brError.readLine();
                    }
                    if (error != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'T', (String)("Errorstream of '" + cmd + "': \n" + error));
                    }
                }
                catch (Exception e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                cmd = "cmd  /c cd " + pgmPath + " && " + pgmPath + "wahttp.exe " + "-u ";
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Removing the \"old\" wahttp service with the following command: ", (char)'I', (String)cmd);
                try {
                    p = run.exec(cmd, null, new File(pgmPath));
                    p.waitFor();
                    brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    input = brInput.readLine();
                    while (brInput.ready()) {
                        input = input + "\n" + brInput.readLine();
                    }
                    if (input != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'T', (String)("InputStream of '" + cmd + "': \n" + input));
                    }
                    error = brError.readLine();
                    while (brError.ready()) {
                        error = error + "\n" + brError.readLine();
                    }
                    if (error != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'T', (String)("Errorstream of '" + cmd + "': \n" + error));
                    }
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                catch (InterruptedException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                cmd = "cmd  /c cd " + pgmPath + " && " + pgmPath + "wahttp.exe " + "-i ";
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Installing the wahttp service with the following command: ", (char)'I', (String)cmd);
                try {
                    p = run.exec(cmd, null, new File(pgmPath));
                    p.waitFor();
                    brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    input = brInput.readLine();
                    while (brInput.ready()) {
                        input = input + "\n" + brInput.readLine();
                    }
                    if (input != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'T', (String)("InputStream of '" + cmd + "': \n" + input));
                    }
                    error = brError.readLine();
                    while (brError.ready()) {
                        error = error + "\n" + brError.readLine();
                    }
                    if (error != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'E', (String)("Errorstream of '" + cmd + "': \n" + error));
                    }
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                catch (InterruptedException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                cmd = "cmd  /c net start \"SAP DB WWW\"";
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Starting the wahttp service with the following command: ", (char)'I', (String)cmd);
                try {
                    p = run.exec(cmd, null, new File(pgmPath));
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                try {
                    p.waitFor();
                    Thread.sleep(WDV_STARTUP_TIME);
                }
                catch (InterruptedException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                try {
                    if (!WDVTestJ_WebDAVTestHelper.isServerRunning(port)) {
                        brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        input = brInput.readLine();
                        while (brInput.ready()) {
                            input = input + "\n" + brInput.readLine();
                        }
                        if (input != null) {
                            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'T', (String)("InputStream of '" + cmd + "': \n" + input));
                        }
                        error = brError.readLine();
                        while (brError.ready()) {
                            error = error + "\n" + brError.readLine();
                        }
                        if (error != null) {
                            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'E', (String)("Errorstream of '" + cmd + "': \n" + error));
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                myTempRegFile.deleteOnExit();
            } else {
                Runtime run = Runtime.getRuntime();
                Process p = null;
                String indepprogpath = "4711";
                try {
                    indepprogpath = TestCase.getDatabase().executeDBMcmd("dbm_getpath indepprogpath");
                    int neededBytes = indepprogpath.length() - "\n".length();
                    indepprogpath = indepprogpath.substring(0, neededBytes);
                }
                catch (TestDatabaseException tdbex) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"trying to receive the indepprogpath which is used to call the wahttp", (char)'E', (String)("An error occured: " + tdbex.getMessage()));
                }
                String asyncPath = indepprogpath + FS + ".." + FS + "TESTDB";
                pgmPath = indepprogpath + FS + "web" + FS + "pgm";
                String LIBPATH = "LD_LIBRARY_PATH";
                if (OS_NAME.indexOf("aix") > -1) {
                    LIBPATH = "LIBPATH";
                }
                String command = LIBPATH + "=" + FS + "SAP_DB" + FS + "programs" + FS + "web" + FS + "lib" + ":" + FS + "SAP_DB" + FS + "programs" + FS + "lib" + ":" + FS + "SAP_DB" + FS + "programs" + FS + "web" + FS + "lib" + FS + "lib64" + ":" + FS + "SAP_DB" + FS + "programs" + FS + "lib" + FS + "lib64" + " && " + "export " + LIBPATH + " && " + "cd " + pgmPath + " && " + "$TOOLSHELL " + asyncPath + FS + "asyncrun.pl " + pgmPath + FS + "wahttp " + "-p " + new Integer(port).toString() + " " + "-f " + FS + "tmp" + FS + "WebAgent" + WDV_VERSION + ".ini";
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"starting the wahttp", (char)'I', (String)("writing a temporary shell script with the following args and execute it: " + command));
                File myTempShellScript = new File(FS + "tmp" + FS + "StartWebDAV.sh");
                String myTempFileContent = command;
                try {
                    FileWriter myTempFW = new FileWriter(myTempShellScript);
                    myTempFW.write(myTempFileContent);
                    myTempFW.flush();
                    myTempFW.close();
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                String chmodNOW = "chmod 755 " + myTempShellScript.toString();
                try {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"RunTime", (char)'I', (String)("Try to execute: " + chmodNOW));
                    p = run.exec(chmodNOW, null, new File(pgmPath));
                    try {
                        Thread.sleep(WDV_STARTUP_TIME);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"chmod returned: ", (char)'I', (String)("return code: " + p.exitValue()));
                    BufferedReader brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String input = brInput.readLine();
                    while (brInput.ready()) {
                        input = input + "\n" + brInput.readLine();
                    }
                    if (input != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'T', (String)("System output while trying to change the permissions of '" + myTempShellScript.toString() + "':" + input));
                    }
                    String error = brError.readLine();
                    while (brError.ready()) {
                        error = error + "\n" + brError.readLine();
                    }
                    if (error != null) {
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'E', (String)("Error while trying to change the permissions of '" + myTempShellScript.toString() + "':" + error));
                    }
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                }
                String runScript = "sh -c " + myTempShellScript.toString();
                try {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"RunTime", (char)'I', (String)("Try to execute: " + runScript));
                    p = run.exec(runScript, null, new File(pgmPath));
                    try {
                        Thread.sleep(WDV_STARTUP_TIME * 2);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Starting of the WAHTTP returned: ", (char)'I', (String)("return code: " + p.exitValue()));
                    if (!WDVTestJ_WebDAVTestHelper.isServerRunning(port)) {
                        BufferedReader brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        BufferedReader brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        String input = brInput.readLine();
                        while (brInput.ready()) {
                            input = input + "\n" + brInput.readLine();
                        }
                        if (input != null) {
                            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"InputStream", (char)'I', (String)("System output while trying to start the wahttp with: \n " + runScript + "\ngetting: " + input));
                        }
                        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"ErrorStream", (char)'I', (String)("ErrorStream.ready = " + brError.ready()));
                    }
                }
                catch (IOException e) {
                    WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public static void stopWebDAV(int port) {
        if (OS_IS_WINDOWS) {
            String[] cmdarray = new String[]{"cmd", "/c", "net stop \"SAP DB WWW\""};
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Stopping the wahttp service with the following command: ", (char)'I', (String)(cmdarray[0] + " " + cmdarray[1] + " " + cmdarray[2]));
            try {
                Runtime.getRuntime().exec(cmdarray);
            }
            catch (IOException e) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
            }
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException e) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
            }
            String cmd = "cmd  /c cd " + pgmPath + " && " + pgmPath + "wahttp.exe " + "-u ";
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Installing the wahttp service with the following command: ", (char)'I', (String)cmd);
            try {
                Runtime.getRuntime().exec(cmd, null, new File(pgmPath));
            }
            catch (IOException e) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
            }
        } else {
            File myPidFile = new File(FS + "SAP_DB" + FS + "data" + FS + "pid" + FS + "serverpids" + FS + "wahttp" + port + ".pid");
            FileReader myPidFileReader = null;
            try {
                myPidFileReader = new FileReader(myPidFile);
            }
            catch (FileNotFoundException fnfex) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"get the process ID from the file 'wahttpxx.pid' in the directory '/SAP_DB/data/pid/serverpid/' to kill any WebDAV processes.", (char)'W', (String)("The file " + myPidFile + " could not be found! The test will be canceled!"));
                return;
            }
            String pidFileContent = new String("");
            BufferedReader myBufPidFileReader = new BufferedReader(myPidFileReader);
            try {
                while (myBufPidFileReader.ready()) {
                    pidFileContent = pidFileContent + myBufPidFileReader.readLine() + "\n";
                }
            }
            catch (IOException ioex) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"get the content of the .pid file", (char)'W', (String)("An " + ioex.getMessage() + " occured. The test will be canceled."));
                return;
            }
            try {
                int beginIndex = 0;
                int endIndex = pidFileContent.indexOf("\n", beginIndex);
                String processID = pidFileContent.substring(beginIndex, endIndex);
                PrintWriter pw = new PrintWriter(System.out);
                String[] cmdarray = new String[]{"kill", "-9", processID};
                PExec p = new PExec(cmdarray, null, new File(FS), pw);
                p.execNoWait();
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("PID-file content: " + pidFileContent);
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)e);
            }
        }
    }

    public void removeLogFiles(String logDir) {
        if (OS_IS_WINDOWS) {
            String[] cmdarray = new String[]{"cmd", "/c", "cd " + logDir + " && rm -f *.log"};
            try {
                Runtime.getRuntime().exec(cmdarray);
            }
            catch (IOException e) {
                this.handleExceptions(e);
            }
        }
    }

    public static String doGetContent(WDVTestJ_WebDAVCore resource, String completeUrl) {
        String contentR = null;
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            contentR = new String(resource.GET());
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("GET http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"GET failed due to some WebDAV feature", (char)'E', (String)"Expected result: 200 OK");
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
        return contentR;
    }

    public static String doGetContentType(WDVTestJ_WebDAVCore resource) {
        String contentTypeR = null;
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            contentTypeR = new String(resource.getResponseHeaders().contentType());
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
        return contentTypeR;
    }

    public static boolean doDelete(WDVTestJ_WebDAVCore resource, String locktoken, String completeUrl) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            if (resource.exists()) {
                resource.DELETE(locktoken);
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 404) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"call DELETE method", (char)'E', (String)("deleting http://" + completeUrl));
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"call DELETE method", (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                return false;
            }
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"call DELETE method", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            return false;
        }
        if (resource.getStatus().getStatusCode() == 204 || resource.getStatus().getStatusCode() == 404) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("deleting http://" + completeUrl), (char)'I', (String)"DELETE OK");
            return true;
        }
        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("deleting http://" + completeUrl), (char)'E', (String)("DELETE failed - HTTP status: " + resource.getStatus().getStatusCode()));
        return false;
    }

    public static boolean doMkCol(WDVTestJ_WebDAVCore resource, String locktoken, String completeUrl) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            resource.MKCOL(locktoken);
            if (resource.getStatus().getStatusCode() == 201) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("Create the collection '" + completeUrl + "'"), (char)'I', (String)"Successful!");
                return true;
            }
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("Create the collection '" + completeUrl + "'"), (char)'E', (String)("collection could not be created - HTTP status: " + resource.getStatus().getStatusCode()));
            return false;
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MKCOL http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            return false;
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MKCOL http://" + completeUrl), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean doPut(WDVTestJ_WebDAVCore resource, String content, String contentType, String locktoken, String completeUrl) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() == 201 || resource.getStatus().getStatusCode() == 204) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PUT http://" + completeUrl), (char)'I', (String)"Successful!");
                return true;
            }
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PUT http://" + completeUrl), (char)'I', (String)("NOT Successful!\nStatus Code: " + resource.getResponseHeaders().getProperty("status")));
            return false;
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PUT http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created"));
            return false;
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
            return false;
        }
    }

    public static boolean doLock(WDVTestJ_WebDAVCore resource, String completeUrl) {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>D041249</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("LOCK " + completeUrl), (char)'I', (String)"resource was locked successfully!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("LOCK " + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Test failed due to some WebDAV feature."));
            return false;
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("LOCK " + completeUrl), (char)'E', (String)("Java exception: " + exc.getMessage() + "\n" + "Test failed due to some Java feature."));
            return false;
        }
        return true;
    }

    public static void doUnlock(WDVTestJ_WebDAVCore resource, String locktoken, String completeUrl) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("UNLOCK " + completeUrl), (char)'I', (String)"setting up the UNLOCK method...successful!");
            resource.UNLOCK(null, locktoken);
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("UNLOCK " + completeUrl), (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "Test failed due to some WebDAV feature."));
            return;
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("UNLOCK " + completeUrl), (char)'E', (String)("Java exception: " + exc.getLocalizedMessage() + "\n" + "Test failed due to some Java feature."));
            return;
        }
    }

    public static void doMove(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"MOVING...", (char)'I', (String)("MOVE with overwrite = '" + overwrite + "'"));
            resource.MOVE(dest_URL, overwrite, body, locktoken);
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'I', (String)"Successful!");
        }
        catch (WDVTestJ_WdvException exc) {
            if (overwrite == "T" && exc.getStatusCode() != 201) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created"));
            }
            if (overwrite == "F" && exc.getStatusCode() != 412) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 412 Precondition failed"));
            }
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
    }

    public static void doMoveThrowingExceptions(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"MOVING...", (char)'I', (String)("MOVE with overwrite = '" + overwrite + "'"));
        resource.MOVE(dest_URL, overwrite, body, locktoken);
        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'I', (String)"Successful!");
    }

    public static void doMove(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken, String depth) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"MOVING", (char)'I', (String)("MOVE with overwrite = '" + overwrite + "'"));
            resource.MOVE(dest_URL, overwrite, body, locktoken, depth);
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'I', (String)"Successful!");
        }
        catch (WDVTestJ_WdvException exc) {
            if (depth.toLowerCase() == "infinity") {
                if (overwrite == "T" && exc.getStatusCode() != 201) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created"));
                }
                if (overwrite == "F" && exc.getStatusCode() != 412) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 412 Precondition failed"));
                }
            }
            if (depth.toLowerCase() != "infinity") {
                if (exc.getStatusCode() != 400) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 400 Bad Request"));
                }
                if (exc.getStatusCode() == 400) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("MOVE TO " + dest_URL + " with depth header unequal 'infinity'"), (char)'I', (String)"Status = '400 Bad Request' as expected");
                }
            }
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
    }

    public static void doCopy(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        if (overwrite == "T") {
            try {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"COPYING", (char)'I', (String)("COPY with overwrite = '" + overwrite + "'"));
                resource.COPY(dest_URL, overwrite, body, locktoken);
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() != 400) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO http://" + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created or 204 No Content"));
                }
            }
            catch (Exception exc) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
            }
        } else {
            try {
                resource.COPY(dest_URL, overwrite, body, locktoken);
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() != 412) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO http://" + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 401 Precondition Failed (with overwrite = 'F' and destination not null"));
                } else {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO http://" + dest_URL), (char)'I', (String)"Copy is not possible with overwrite = 'F' and destination not null...OK");
                }
            }
            catch (Exception exc) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
            }
        }
    }

    public static boolean doCopy(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken, String depth) {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        if (overwrite == "T") {
            try {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"COPYING", (char)'I', (String)("COPY with overwrite = '" + overwrite + "'"));
                resource.COPY(dest_URL, overwrite, body, locktoken, depth);
                return true;
            }
            catch (WDVTestJ_WdvException exc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO http://" + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created or 204 No Content"));
                return false;
            }
            catch (Exception exc) {
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
                return false;
            }
        }
        try {
            resource.COPY(dest_URL, overwrite, body, locktoken, depth);
            return true;
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 412) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO " + dest_URL), (char)'I', (String)"Copy is not possible with overwrite = 'F' and destination not null...OK");
                return true;
            }
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("COPY TO " + dest_URL), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 401 Precondition Failed (with overwrite = 'F' and destination not null)"));
            return false;
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
            return false;
        }
    }

    public static void doCopyThrowingExceptions(WDVTestJ_WebDAVCore resource, String dest_URL, String overwrite, String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        if (overwrite == "T") {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"COPYING", (char)'I', (String)("COPY with overwrite = '" + overwrite + "'"));
            resource.COPY(dest_URL, overwrite, body, locktoken);
        } else {
            resource.COPY(dest_URL, overwrite, body, locktoken);
        }
    }

    public static boolean compareContent(WDVTestJ_WebDAVCore resource, String content, String contentType, long contentLength, String completeUrl) {
        boolean test_was_ok = true;
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            String contentR = new String(resource.GET());
            long contentLengthR = resource.getResponseHeaders().contentLength();
            if (contentLengthR != contentLength) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'E', (String)("Recieved content length (" + contentLengthR + ") not equal to expected content length (" + contentLength + ")"));
                test_was_ok = false;
            } else if (content.compareTo(contentR) != 0) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'E', (String)("Recieved content not equal to expected content.\nExpected content:\n" + content + "\n" + "Recieved content:\n" + contentR));
                test_was_ok = false;
            } else {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'I', (String)"Recieved content equals expected content\nTest was successful.");
            }
            String contentTypeR = resource.getResponseHeaders().contentType();
            if (contentTypeR.compareTo(contentType) != 0) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'E', (String)("Recieved content type (" + contentTypeR + ") not equal to expected content type (" + contentType + ")"));
                test_was_ok = false;
            } else {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'I', (String)"Recieved content type equals expected content type\nTest was successful.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("CHECK: GET http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 200 OK"));
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
        return test_was_ok;
    }

    public static Document doPropfind(WDVTestJ_WebDAVCore resource, String body, String completeUrl) {
        Document xmlbody = null;
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            xmlbody = resource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Method failed due to some WebDAV feature"));
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("Java exception: " + exc.getMessage() + "\n" + "Method failed due to some Java feature"));
        }
        return xmlbody;
    }

    public static String doPropfindByTagName(WDVTestJ_WebDAVCore resource, String elementname, String completeUrl) {
        Document xmlbody = null;
        String element_val = null;
        Node element_node = null;
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\">\n";
        body = body + "<D:prop>\n";
        body = body + "<D:" + elementname + "/>\n";
        body = body + "</D:prop>\n";
        body = body + "</D:propfind>\n";
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            xmlbody = resource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Method failed due to some WebDAV feature"));
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
        try {
            NodeList nl = xmlbody.getElementsByTagName("s1:" + elementname);
            if (nl.getLength() == 0) {
                nl = xmlbody.getElementsByTagName("D:" + elementname);
            }
            element_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("retrieving the 's1:" + elementname + "'-element"), (char)'E', (String)("the '" + elementname + "'-element for the resource could not be retrieved"));
        }
        String status = null;
        status = xmlbody.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
        if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
            try {
                element_val = element_node.getFirstChild().getNodeValue().toString();
            }
            catch (NullPointerException npexc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("receiving the value of the '" + elementname + "'-node for the resource"), (char)'E', (String)("value of '" + elementname + "'-node is not existing"));
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)npexc);
            }
        } else {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("receiving '" + elementname + "'-node for the resource"), (char)'E', (String)("'" + elementname + "'-node is not existing" + "\n" + "status code: " + status));
        }
        if (resource.getStatus().getStatusCode() != 207) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "207 Multistatus expected"));
        }
        return element_val;
    }

    public static String doPropfindByTagName(WDVTestJ_WebDAVCore resource, String namespace, String elementname, String completeUrl) {
        Document xmlbody = null;
        String element_val = null;
        Node element_node = null;
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\" xmlns:N=\"" + namespace + "\">\n";
        body = body + "<D:prop>\n";
        body = body + "<N:" + elementname + "/>\n";
        body = body + "</D:prop>\n";
        body = body + "</D:propfind>\n";
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            xmlbody = resource.PROPFIND(body);
        }
        catch (WDVTestJ_WdvException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Method failed due to some WebDAV feature"));
        }
        catch (Exception exc) {
            WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
        }
        try {
            NodeList nl = xmlbody.getElementsByTagName("s1:" + elementname);
            if (nl.getLength() == 0) {
                nl = xmlbody.getElementsByTagName("N:" + elementname);
            }
            element_node = nl.item(0);
        }
        catch (NullPointerException exc) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("retrieving the 's1:" + elementname + "'-element"), (char)'E', (String)("the '" + elementname + "'-element for the resource could not be retrieved"));
        }
        String status = null;
        status = xmlbody.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
        if (status.equalsIgnoreCase("HTTP/1.1 200 OK")) {
            try {
                element_val = element_node.getFirstChild().getNodeValue().toString();
            }
            catch (NullPointerException npexc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("receiving the value of the '" + elementname + "'-node for the resource"), (char)'E', (String)("value of '" + elementname + "'-node is not existing"));
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)npexc);
            }
        } else {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("receiving '" + elementname + "'-node for the resource"), (char)'E', (String)("'" + elementname + "'-node is not existing" + "\n" + "status code: " + status));
        }
        if (resource.getStatus().getStatusCode() != 207) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "207 Multistatus expected"));
        }
        return element_val;
    }

    public static String getLockToken(WDVTestJ_WebDAVCore resource, String completeUrl) {
        Document xmlbody = null;
        String lockTokenVal = null;
        Node lockTokenNode = null;
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "<D:propfind xmlns:D=\"DAV:\">\n";
        body = body + "<D:prop>\n";
        body = body + "<D:lockdiscovery/>\n";
        body = body + "</D:prop>\n";
        body = body + "</D:propfind>\n";
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        if (resource.exists()) {
            try {
                xmlbody = resource.PROPFIND(body, "0");
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'I', (String)("Trying to receive the locktoken for " + completeUrl));
            }
            catch (WDVTestJ_WdvException exc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Method failed due to some WebDAV feature"));
            }
            catch (Exception exc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("PROPFIND http://" + completeUrl), (char)'E', (String)("Java exception: " + exc));
            }
            try {
                NodeList nl = xmlbody.getElementsByTagName("D:locktoken");
                if (nl.getLength() == 0) {
                    nl = xmlbody.getElementsByTagName("locktoken");
                }
                if ((lockTokenNode = nl.item(0)) == null) {
                    return null;
                }
                lockTokenNode.getFirstChild();
            }
            catch (NullPointerException exc) {
                return null;
            }
            try {
                Node hrefNode = lockTokenNode.getFirstChild();
                lockTokenVal = hrefNode.getFirstChild().getNodeValue();
            }
            catch (NullPointerException npexc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"receiving the value of the 'locktoken'-node for the resource", (char)'E', (String)"value of 'locktoken'-node is not existing");
                npexc.printStackTrace();
            }
            if (resource.getStatus().getStatusCode() != 207) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "207 Multistatus expected"));
            }
        }
        return lockTokenVal;
    }

    protected static boolean isServerRunning(int port) {
        String host = new String(WDVTestJ_WebDAVTestHelper.getParameterString((String)"host", (String)"localhost"));
        String baseUrl = WDVTestJ_WebDAVTestHelper.getParameterString((String)"baseUrl", (String)"/webdav");
        boolean serverRuns = false;
        String content = "4711";
        WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)("isServerRunning(" + port + ")"), (char)'I', (String)"");
        if (!WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"use_servlet is F -> ping the wahttp to check whether it is running or not", (char)'I', (String)WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F"));
            WDVTestJ_WebDAVCore resource = new WDVTestJ_WebDAVCore().createResource(host, port, baseUrl, "?ping");
            if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
                resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
            }
            try {
                content = new String(resource.GET());
            }
            catch (WDVTestJ_WdvException ex) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Server Running Exception", (char)'E', (String)(ex.getStatusCode() + " " + ex.getMessage()));
                return serverRuns;
            }
            catch (NullPointerException npex) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Server Running Exception", (char)'E', (String)npex.getMessage());
                return serverRuns;
            }
            catch (IOException exc) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"Server Running Exception", (char)'E', (String)exc.getMessage());
                WDVTestJ_WebDAVTestHelper.handleGlobalExceptions((Exception)exc);
            }
            if (content.indexOf("SAP DB WWW WebDAV") != -1) {
                serverRuns = true;
            }
        } else {
            WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"use_servlet is T. assume server running", (char)'I', (String)WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F"));
            serverRuns = true;
        }
        return serverRuns;
    }

    protected boolean isServiceRunning(int port) {
        String host = new String(WDVTestJ_WebDAVTestHelper.getParameterString((String)"host", (String)"localhost"));
        String baseUrl = WDVTestJ_WebDAVTestHelper.getParameterString((String)"baseUrl", (String)"/webdav");
        boolean serviceRuns = false;
        String urlStr = new String("/is_the_service_running.test");
        WDVTestJ_WebDAVCore resource = new WDVTestJ_WebDAVCore().createResource(host, port, baseUrl, urlStr);
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            resource.HEAD(null);
        }
        catch (WDVTestJ_WdvException wdvex) {
            serviceRuns = wdvex.getStatusCode() == 404;
        }
        catch (NullPointerException npex) {
            this.handleExceptions(npex);
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        return serviceRuns;
    }

    protected boolean isServiceConfigCorrect(int port) {
        String host = new String(WDVTestJ_WebDAVTestHelper.getParameterString((String)"host", (String)"localhost"));
        String baseUrl = WDVTestJ_WebDAVTestHelper.getParameterString((String)"baseUrl", (String)"/webdav");
        boolean isServiceConfigCorrect = true;
        String content = "4711";
        WDVTestJ_WebDAVCore resource = new WDVTestJ_WebDAVCore().createResource(host, port, baseUrl, "/isServiceConfigCorrect.txt");
        if (WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_basic_auth", (String)"F").equalsIgnoreCase("T")) {
            resource.setBasicAuthorization(WDVTestJ_WebDAVTestHelper.getBasicAuthUser(), WDVTestJ_WebDAVTestHelper.getBasicAuthPwd());
        }
        try {
            content = new String(resource.HEAD(null));
        }
        catch (WDVTestJ_WdvException ex) {
            if (ex.getStatusCode() == 500) {
                isServiceConfigCorrect = false;
                this.handleExceptions(ex);
            } else if (ex.getStatusCode() == 404) {
                isServiceConfigCorrect = true;
            }
        }
        catch (NullPointerException npex) {
            isServiceConfigCorrect = false;
            this.handleExceptions(npex);
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        if (content.indexOf("The page cannot be displayed") == -1) {
            isServiceConfigCorrect = true;
        }
        return isServiceConfigCorrect;
    }

    protected static void createWebDAVSchema() {
        if (!WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            try {
                if (!WDVTestJ_WebDAVCore.createWebDAVSchema(WDVTestJ_WebDAVTestHelper.getDatabase().connect(WDVTestJ_WebDAVTestHelper.getParameterString((String)"dbuser", (String)WDVTestJ_WebDAVTestHelper.getDatabase().getDBAUser()), WDVTestJ_WebDAVTestHelper.getParameterString((String)"passwd", (String)WDVTestJ_WebDAVTestHelper.getDatabase().getDBAPassword())), ((TestDatabaseSap)WDVTestJ_WebDAVTestHelper.getDatabase()).getKernelVersion(), WDVTestJ_WebDAVTestHelper.getParameterString((String)"use_servlet", (String)"F"))) {
                    WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"preparation for test-execution", (char)'E', (String)"WebDAV schema not found or not creatable");
                }
            }
            catch (TestDatabaseException e) {
                WDVTestJ_WebDAVTestHelper.addGlobalMessage((String)"preparation for test-execution", (char)'E', (String)e.getMessage());
            }
        }
    }

    static {
        FS = System.getProperty("file.separator");
        OS_ARCHITECTURE = 0;
        pgmPath = "";
        LOG_DIR = FS + "var" + FS + "log" + FS + "sapdb" + FS + "wa" + FS + "mydir";
        WDV_STARTUP_TIME = 30000;
        start_server = false;
    }
}

