/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2.util;

import java.io.PrintStream;

public class Logger {
    public static short CURRDEBUG = (short)100;
    public static short QUIET = (short)40;
    public static short STANDARD = (short)30;
    public static short VERBOSE = (short)20;
    public static short DEBUG = (short)10;
    private static String[] levels = new String[]{"DEBUG", "VERBOSE", "STANDARD", "QUIET"};
    private static short level = STANDARD;
    private static boolean printStackTraces = false;
    public static PrintStream out = System.out;
    public static PrintStream err = System.err;

    public static synchronized void error(String string) {
        out.flush();
        err.println(Logger.log_prefix() + "*** ERROR *** " + string);
        err.flush();
    }

    public static synchronized void warning(String string) {
        out.flush();
        err.println(Logger.log_prefix() + "*** WARNING *** " + string);
        err.flush();
    }

    public static void setLevel(short s) {
        level = s;
    }

    public static short getLevel() {
        return level;
    }

    public static synchronized void log(int n, String string) {
        System.out.println(string);
    }

    public static boolean setLevel(String string) {
        if (string.equalsIgnoreCase("DEBUG")) {
            level = DEBUG;
            printStackTraces = true;
            return true;
        }
        if (string.equalsIgnoreCase("VERBOSE")) {
            level = VERBOSE;
            return true;
        }
        if (string.equalsIgnoreCase("STANDARD")) {
            level = STANDARD;
            return true;
        }
        if (string.equalsIgnoreCase("QUIET")) {
            level = QUIET;
            return true;
        }
        level = STANDARD;
        return false;
    }

    private static String log_prefix() {
        return "[UpgradeTest] ";
    }

    public static void stackTrace(Exception exception) {
        if (printStackTraces) {
            exception.printStackTrace(out);
        }
    }

    public static boolean isPrintStackTraces() {
        return printStackTraces;
    }

    public static void setPrintStackTraces(boolean bl) {
        printStackTraces = bl;
    }
}

