/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.sapdb.lctest.DataConsistencyException;
import com.sap.sapdb.oltptest.mut.OLTPConstants;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.sql.Connection;
import java.sql.Statement;

public abstract class OLTPTestActor
extends Thread
implements OLTPConstants {
    public static final int RES_NO_ERROR = 0;
    public static final int RES_FINISHED_LOOPS = 1;
    public static final int RES_INTERRUPTED = 2;
    public static final int RES_SHUTDOWN_COMPLETE = 3;
    public static final int RES_SHUTDOWN_START = 4;
    public static final int RES_WAIT_TO_SHUTDOWN = 5;
    public static final int ERR_CONSISTENCY_ERROR = -1;
    public static final int ERR_SQL_ERROR = -2;
    public static final int ERR_GENERAL_ERROR = -3;
    protected String mTitle;
    protected int mStatus = 0;
    protected String mStatusMessage = "No errors";
    protected Connection mConnection;
    protected Statement mStatement;
    protected TestPreparedStatement mPreparedStatement;
    protected boolean mRunning = false;
    protected boolean mShouldStop = false;
    protected boolean mTraceOn = false;
    public static final int SQL_ACTOR = 4;

    public OLTPTestActor() {
    }

    public OLTPTestActor(Runnable target) {
        super(target);
    }

    public OLTPTestActor(Runnable target, String name) {
        super(target, name);
    }

    public OLTPTestActor(String name) {
        super(name);
    }

    public OLTPTestActor(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public OLTPTestActor(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public OLTPTestActor(ThreadGroup group, String name) {
        super(group, name);
    }

    public abstract void check() throws DataConsistencyException;

    protected void cleanup() {
        try {
            this.mStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public final String getStatusMessage() {
        return this.mStatusMessage;
    }

    public final String getTitle() {
        return this.mTitle;
    }

    public final boolean hasError() {
        return this.mStatus < 0;
    }

    public final boolean isRunning() {
        return this.mRunning;
    }

    public abstract void run();

    protected final void setStatus(int Status) {
        this.mStatus = Status;
        switch (Status) {
            case 0: {
                this.mStatusMessage = "No errors";
                break;
            }
            case 2: {
                this.mStatusMessage = "Interrupted by master thread";
                break;
            }
            case 1: {
                this.mStatusMessage = "Finished the loops successfully";
                break;
            }
            case -1: {
                this.mStatusMessage = "Data Inconsistency";
                break;
            }
            case -2: {
                this.mStatusMessage = "SQL error";
                break;
            }
            case -3: {
                this.mStatusMessage = "General error";
                break;
            }
            case 4: {
                this.mStatusMessage = "Shutdown started";
                break;
            }
            case 3: {
                this.mStatusMessage = "Shutdown completed";
                break;
            }
            case 5: {
                this.mStatusMessage = "waiting to kill";
            }
        }
    }

    protected final void setStatus(int Status, String StatusMessage) {
        this.mStatus = Status;
        this.mStatusMessage = StatusMessage;
    }

    public final void setTitle(String newTitle) {
        this.mTitle = newTitle;
    }

    public final void shouldStop() {
        this.mShouldStop = true;
    }
}

