/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;

public class MutSQLDBCStarter
extends TestCase {
    private static int noOfLoops = 1;
    private static boolean stopOnError = true;
    private static String additionalParamterForMutparam;
    private static String additionalParamterForMuti;
    private static String instRoot;
    private static String jtestRoot;
    private static String fileSep;
    private static String osVersion;
    private static String osUser;
    private static String osPassword;
    private static String kernelMode;
    private static String dbName;
    private static String cfgFileForMutParam;
    private static boolean cluster;

    static {
        cfgFileForMutParam = "";
    }

    public static void prepare() {
        noOfLoops = new Integer(TestCase.getParameterString((String)"noOfLoops", (String)"1"));
        kernelMode = TestCase.getParameterString((String)"kernelMode", (String)"-f").trim();
        cfgFileForMutParam = TestCase.getParameterString((String)"cfgFile", (String)"").trim();
        stopOnError = TestCase.getParameterBoolean((String)"stopOnError", (boolean)true);
        additionalParamterForMutparam = TestCase.getParameterString((String)"additionalParamterForMutparam", (String)"").trim();
        additionalParamterForMuti = TestCase.getParameterString((String)"additionalParamterForMuti", (String)"").trim();
        cluster = TestCase.getParameterBoolean((String)"Cluster", (boolean)false);
    }

    public static long getTimeout() {
        long dummyTime = 0L;
        dummyTime = noOfLoops * 10 < 120 ? 0x6DDD00L : (long)(noOfLoops * 10 * 1000 * 60);
        if (kernelMode != null && kernelMode.equalsIgnoreCase("-s")) {
            dummyTime *= 2L;
        }
        return dummyTime;
    }

    public static String getTestClassId() {
        return "MutSQLDBCStarter";
    }

    public void run() {
        block30: {
            StringBuffer sb = null;
            try {
                String theDump;
                File theDumpFile;
                StringBuffer bufferWithAllParamter = new StringBuffer();
                bufferWithAllParamter.append("The " + MutSQLDBCStarter.getTestClassId() + " uses default parameter and the parameter \n file: '" + this.getParameterFileLocation() + "'\n with the following values:\n\n");
                bufferWithAllParamter.append("\tnoOfLoops                      = " + noOfLoops + "\n");
                bufferWithAllParamter.append("\tkernelMode                     = '" + kernelMode + "'\n");
                bufferWithAllParamter.append("\tcfgFile                        = '" + cfgFileForMutParam + "'");
                if (cfgFileForMutParam.length() < 4) {
                    bufferWithAllParamter.append(" -> not explicit set; determined within the test\n");
                }
                bufferWithAllParamter.append("\tstopOnError                    = " + stopOnError + "\n");
                bufferWithAllParamter.append("\tCluster                        = " + cluster + "\n");
                bufferWithAllParamter.append("\tadditionalParamterForMutparam  = '" + additionalParamterForMutparam + "'\n");
                bufferWithAllParamter.append("\tadditionalParamterForMuti      = '" + additionalParamterForMuti + "'\n");
                System.out.println(bufferWithAllParamter.toString());
                TestCase.addGlobalMessage((String)"Test configuration", (char)'I', (String)bufferWithAllParamter.toString());
                instRoot = TestCase.mTestDriverOptions.getProperty("DBRoot");
                if (instRoot == null) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). DBROOT not set.");
                    throw new TestCaseException("DBROOT not set.");
                }
                jtestRoot = System.getProperty("jtest.root");
                if (jtestRoot == null) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). Property jtest.root not set.");
                    throw new TestCaseException("Property jtest.root not set.");
                }
                fileSep = System.getProperty("file.separator");
                osVersion = TestDriver.getOpSystem().substring(0, 3);
                if (!osVersion.equalsIgnoreCase("WIN")) {
                    osUser = TestCase.mTestDriverOptions.getProperty("OSUser");
                    osPassword = TestCase.mTestDriverOptions.getProperty("OSPwd");
                }
                if (!(kernelMode.equals("-f") || kernelMode.equals("-s") || kernelMode.equals("-t"))) {
                    TestCase.addGlobalMessage((String)"unknown kernel mode", (char)'W', (String)("Replaced the given, unknown kernel mode '" + kernelMode + "' with '-f'."));
                    kernelMode = "-f";
                }
                dbName = TestCase.getDatabase().getName();
                FileWriter writer = new FileWriter(new File(String.valueOf(System.getProperty("jtest.root")) + fileSep + "mutsqldbc" + fileSep + "mutvar"));
                String mutvar = dbName + " " + TestCase.getDatabase().getDBAUser() + " " + TestCase.getDatabase().getDBAPassword() + " " + TestCase.getDatabase().getDBMUser() + " " + TestCase.getDatabase().getDBMPassword() + "\n";
                TestCase.addGlobalMessage((String)"write mutvar", (char)'I', (String)("Write the file 'mutvar' with content:\n" + mutvar));
                writer.write(mutvar);
                writer.close();
                String cmd = "perl " + jtestRoot + fileSep + "mutsqldbc" + fileSep + "mutparam.pl ";
                if (instRoot != null && !instRoot.equals("")) {
                    cmd = String.valueOf(cmd) + "-R " + instRoot;
                }
                if (!osVersion.equalsIgnoreCase("WIN") && osUser != null && osPassword != null) {
                    cmd = String.valueOf(cmd) + " -l " + osUser + "," + osPassword;
                }
                Calendar calendar = Calendar.getInstance();
                int dayOfMonth = calendar.get(5);
                if (cfgFileForMutParam != null && cfgFileForMutParam.trim().length() < 4) {
                    cfgFileForMutParam = dayOfMonth % 2 == 0 ? (noOfLoops > 29 ? "unicode_big.cfg" : "unicode_small.cfg") : (noOfLoops > 29 ? "ascii_big.cfg" : "ascii_small.cfg");
                }
                cmd = String.valueOf(cmd) + " -cfg " + cfgFileForMutParam;
                if (additionalParamterForMutparam != null && additionalParamterForMutparam.length() > 0) {
                    cmd = String.valueOf(cmd) + " " + additionalParamterForMutparam;
                }
                sb = new StringBuffer();
                sb.append(cmd);
                System.out.println("Executing command:");
                System.out.println(" " + sb.toString());
                TestCase.addGlobalMessage((String)"mutparam", (char)'I', (String)("Executing command:\n '" + sb.toString() + "'\n in: " + jtestRoot + fileSep + "mutsqldbc" + fileSep));
                sb = new StringBuffer();
                Execute exc = new Execute(cmd, null, sb);
                exc.exec(new File(String.valueOf(jtestRoot) + fileSep + "mutsqldbc"));
                int errorCode = 0;
                errorCode = exc.getExitValue();
                if (errorCode > 255) {
                    errorCode -= 65536;
                } else if (errorCode > 127) {
                    errorCode -= 256;
                }
                if (errorCode != 0) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)(String.valueOf(cmd) + " => RC = " + errorCode));
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). mutparam.pl failed.");
                    if (sb.toString().length() != 0) {
                        TestCase.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                    }
                    throw new TestCaseException("mutparam failed.");
                }
                TestCase.addGlobalMessage((String)"", (char)'I', (String)(String.valueOf(cmd) + " successful!"));
                cmd = "perl " + jtestRoot + fileSep + "mutsqldbc" + fileSep + "muti.pl ";
                if (instRoot != null && !instRoot.equals("")) {
                    cmd = String.valueOf(cmd) + "-R " + instRoot;
                }
                cmd = String.valueOf(cmd) + " " + kernelMode;
                if (additionalParamterForMuti != null && additionalParamterForMuti.length() > 0) {
                    cmd = String.valueOf(cmd) + " " + additionalParamterForMuti;
                }
                if (stopOnError) {
                    cmd = String.valueOf(cmd) + " -stoponerror";
                }
                if (cluster) {
                    cmd = String.valueOf(cmd) + " -cluster";
                }
                cmd = String.valueOf(cmd) + " " + noOfLoops;
                long startTime = System.currentTimeMillis();
                sb = new StringBuffer();
                sb.append("Executing command:\n '" + cmd + "'\n with a timeout of " + MutSQLDBCStarter.getTimeout() / 1000L / 60L + " min ");
                System.out.println(sb.toString());
                TestCase.addGlobalMessage((String)"muti", (char)'I', (String)(String.valueOf(sb.toString()) + "\n in: " + jtestRoot + fileSep + "mutsqldbc" + fileSep));
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.exec(new File(String.valueOf(jtestRoot) + fileSep + "mutsqldbc"));
                long endTime = System.currentTimeMillis();
                errorCode = 0;
                errorCode = exc.getExitValue();
                if (errorCode > 255) {
                    errorCode -= 65536;
                } else if (errorCode > 127) {
                    errorCode -= 256;
                }
                if (errorCode == 0) {
                    TestCase.addGlobalMessage((String)"", (char)'I', (String)(String.valueOf(cmd) + " successful!"));
                    if (sb.toString().length() != 0 && (sb.toString().indexOf("coredump") != -1 || sb.toString().indexOf("core") != -1)) {
                        TestCase.addGlobalMessage((String)"stdout contains the word 'coredump' or 'core'", (char)'E', (String)sb.toString());
                    }
                } else {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)(String.valueOf(cmd) + " => RC = " + errorCode));
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). muti.pl failed.");
                    if (sb.toString().length() != 0) {
                        TestCase.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                    }
                }
                if (endTime - startTime < 360000L && noOfLoops > 9) {
                    TestCase.addGlobalMessage((String)"run()", (char)'E', (String)("The script 'muti.pl' with a loop counter of " + noOfLoops + " has finished in less than six minutes. \nRuntime: " + (endTime - startTime) / 1000L + " sec. It is almost certain that there have been undetected errors."));
                }
                if ((theDumpFile = new File(theDump = String.valueOf(jtestRoot) + fileSep + "mutsqldbc" + fileSep + "dump.prt")).exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(theDumpFile));
                    String line = reader.readLine();
                    StringBuffer contentOfDUMP = new StringBuffer();
                    contentOfDUMP.append("The file: dump.prt (" + theDump + ") exists and \nhas the following content:\n\n");
                    while (line != null) {
                        contentOfDUMP.append(line);
                        contentOfDUMP.append("\n");
                        line = reader.readLine();
                    }
                    this.addMessage("run() - dump.prt file", 'E', contentOfDUMP.toString());
                }
            }
            catch (Exception e) {
                this.addMessage("run()", 'E', "Exception: " + e.getMessage());
                if (sb == null || sb.toString().length() <= 3) break block30;
                this.addMessage("run()", 'T', "TestOutPut until the error: \n" + sb.toString());
            }
        }
    }

    public String getLogFile() {
        File theZipFile = new File(String.valueOf(this.getDataOutputPath()) + File.separator + "mutsqldbc_prot.zip");
        Zipper myZipper = new Zipper(theZipFile);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean acceptFilter = false;
                acceptFilter = MutSQLDBCStarter.this.isInterrupted() ? name.endsWith(".prt") || name.endsWith(".prot") : name.endsWith(".prt");
                return acceptFilter;
            }
        };
        File[] filelist = new File(String.valueOf(jtestRoot) + fileSep + "mutsqldbc").listFiles(filter);
        myZipper.addFiles(filelist);
        myZipper.addFile(new File(String.valueOf(jtestRoot) + fileSep + "mutsqldbc" + fileSep + "endlos.prot"));
        try {
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("getLogFile", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
            return String.valueOf(jtestRoot) + fileSep + "mutsqldbc" + fileSep + "endlos.prot";
        }
        return theZipFile.getAbsolutePath();
    }
}

