/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DuplicateTableException;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class OperatorTableDefinition
extends TableDefinition {
    private Map columnMap = new HashMap();
    private List containedTablesList = new ArrayList();

    public OperatorTableDefinition(TableDefinition definition) {
        super(definition);
    }

    public OperatorTableDefinition() {
    }

    public Iterator containedTablesIterator() {
        return this.containedTablesList.iterator();
    }

    public int getColumnBaseOffset(TableDefinition def) {
        if (def == this) {
            return 1;
        }
        Assertion.assertTrue(def.getTableName() != null);
        Integer offset = (Integer)this.columnMap.get(def.getTableName());
        if (offset == null) {
            throw new NoSuchElementException();
        }
        return offset;
    }

    public void addInputTable(Table inputTable) {
        this.containedTablesList.add(inputTable);
        Integer startColumn = new Integer(this.getColumnCount() + 1);
        if (this.columnMap.get(inputTable.getTableName()) != null) {
            throw new DuplicateTableException(inputTable.getTableName());
        }
        this.columnMap.put(inputTable.getTableName(), startColumn);
        Iterator it = inputTable.columnIterator();
        while (it.hasNext()) {
            Column originalCol = (Column)it.next();
            Column newCol = (Column)originalCol.clone();
            newCol.setColumnName(originalCol.getColumnName());
            this.addColumn(newCol);
        }
    }
}

