/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.OuterJoin;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class FullOuterJoin
extends OuterJoin {
    private ResultTable leftTable;
    private ResultTable rightTable;
    private AbstractCondition qualification;
    private boolean doLeftOuterJoin;
    private TableRow currentRow;
    private TableRow curLeftRow;
    private TableRow curRightRow;
    private TableRow nullLeftRow;
    private TableRow nullRightRow;
    private boolean rowAlreadyQualified;
    private boolean valueReady = false;

    public FullOuterJoin(ResultTable leftTable, ResultTable rightTable, AbstractCondition qualification) {
        super(leftTable, rightTable);
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.qualification = qualification;
        this.qualification.prepare(this);
        this.currentRow = new TableRow(this);
        this.nullLeftRow = this.createNullRow(this.leftTable.getTableDefinition());
        this.nullRightRow = this.createNullRow(this.rightTable.getTableDefinition());
        this.doLeftOuterJoin = true;
        this.resetIterator();
    }

    private boolean hasNextLeftOuterJoinRow() {
        if (this.curLeftRow == null) {
            if (!this.leftTable.hasNext()) {
                return false;
            }
            this.curLeftRow = this.leftTable.next();
        }
        while (true) {
            boolean rowFound = false;
            while (this.rightTable.hasNext()) {
                TableRow curRightRow = this.rightTable.next();
                TableRow.mergeRows(this.currentRow, this.curLeftRow, curRightRow);
                if (!this.qualification.isTrue(this.currentRow)) continue;
                this.rowAlreadyQualified = true;
                return true;
            }
            if (!this.rowAlreadyQualified) {
                TableRow.mergeRows(this.currentRow, this.curLeftRow, this.nullRightRow);
                this.rowAlreadyQualified = true;
                return true;
            }
            if (!this.leftTable.hasNext()) {
                this.curLeftRow = null;
                return false;
            }
            this.curLeftRow = this.leftTable.next();
            this.rightTable.resetIterator();
            this.rowAlreadyQualified = false;
        }
    }

    private boolean hasNextRightOuterJoinRow() {
        if (this.curRightRow == null) {
            if (!this.rightTable.hasNext()) {
                return false;
            }
            this.curRightRow = this.leftTable.next();
        }
        while (true) {
            boolean rowFound = false;
            while (this.leftTable.hasNext() && !this.rowAlreadyQualified) {
                TableRow curLeftRow = this.leftTable.next();
                TableRow.mergeRows(this.currentRow, curLeftRow, this.curRightRow);
                if (!this.qualification.isTrue(this.currentRow)) continue;
                this.rowAlreadyQualified = true;
            }
            if (!this.rowAlreadyQualified) {
                TableRow.mergeRows(this.currentRow, this.nullLeftRow, this.curRightRow);
                this.rowAlreadyQualified = true;
                return true;
            }
            if (!this.rightTable.hasNext()) {
                this.curRightRow = null;
                return false;
            }
            this.curRightRow = this.rightTable.next();
            this.leftTable.resetIterator();
            this.rowAlreadyQualified = false;
        }
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (this.doLeftOuterJoin) {
            if (this.hasNextLeftOuterJoinRow()) {
                this.valueReady = true;
                return true;
            }
            this.leftTable.resetIterator();
            this.rightTable.resetIterator();
            if (this.rightTable.hasNext()) {
                this.curRightRow = this.rightTable.next();
            }
            this.doLeftOuterJoin = false;
            this.rowAlreadyQualified = false;
            return this.hasNext();
        }
        this.valueReady = this.hasNextRightOuterJoinRow();
        return this.valueReady;
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.leftTable.resetIterator();
        if (this.leftTable.hasNext()) {
            this.curLeftRow = this.leftTable.next();
        }
        this.rightTable.resetIterator();
        this.rowAlreadyQualified = false;
        this.doLeftOuterJoin = true;
        this.valueReady = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "FullOuterJoinOperator " + this.getTableName());
        s.println(String.valueOf(indentStr) + "  Qualification:");
        this.qualification.dumpStructure(s, String.valueOf(indentStr) + "    ");
        s.println(String.valueOf(indentStr) + "  Input:");
        this.leftTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
        this.rightTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
    }
}

