/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.ComparisonCondition;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;

public class EqualCondition
extends ComparisonCondition {
    public EqualCondition(Table leftTable, int leftColumnNumber, Table rightTable, int rightColumnNumber) {
        super(leftTable, leftColumnNumber, rightTable, rightColumnNumber);
    }

    public String getConditionName() {
        return "EqualCondition";
    }

    public String getOperatorString() {
        return "=";
    }

    public boolean isTrue(TableRow row) {
        AbstractCell leftValue = row.getValue(this.leftColumnNumber + this.leftRowBaseColumnNo);
        AbstractCell rightValue = row.getValue(this.rightColumnNumber + this.rightRowBaseColumnNo);
        if (leftValue.isNull() || rightValue.isNull()) {
            return false;
        }
        return leftValue.isEqual(rightValue);
    }

    public boolean isFalse(TableRow leftRow) {
        return !this.isTrue(leftRow);
    }
}

