/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;

public class CharacterCell
extends AbstractCell
implements Cloneable {
    String value;

    public String getType() {
        return "CharacterCell";
    }

    public CharacterCell(String value) {
        this.value = value;
    }

    public boolean isEqual(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value.equals(otherCell.getValue());
    }

    public boolean isGreater(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value.compareTo(otherCell.getValue()) > 0;
    }

    public boolean isLess(AbstractCell otherCell) {
        if (otherCell.isNull()) {
            throw new NullPointerException();
        }
        return this.value.compareTo(otherCell.getValue()) < 0;
    }

    public String getValue() {
        return this.value;
    }

    public Object clone() {
        CharacterCell c = (CharacterCell)super.clone();
        c.value = this.value;
        return c;
    }

    public boolean isNull() {
        return false;
    }

    public String getSqlLiteral() {
        return "'" + this.value + "'";
    }
}

