/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

import com.sap.sapdb.oltptest.join.description.JoinPredicate;
import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import java.util.AbstractList;

public class NaturalJoin
extends JoinPredicate {
    private String colName;
    private String[] tableNames;

    public NaturalJoin(String colName, String tableName0, String tableName1) {
        this.colName = colName;
        this.tableNames = new String[]{tableName0, tableName1};
    }

    public void createColumns(JoinQuery join) {
        int i = 0;
        while (i < this.tableNames.length) {
            TableDescription table = join.findTable(this.tableNames[i]);
            table.addColumn(this.colName, null);
            ++i;
        }
    }

    public String asSQL() {
        String col0 = String.valueOf(this.tableNames[0]) + "." + this.colName;
        String col1 = String.valueOf(this.tableNames[1]) + "." + this.colName;
        return String.valueOf(col0) + " = " + col1;
    }

    public boolean suitableForOn(String newTableName, AbstractList usedTables) {
        if (newTableName.equals(this.tableNames[0])) {
            return usedTables.contains(this.tableNames[1]);
        }
        if (newTableName.equals(this.tableNames[1])) {
            return usedTables.contains(this.tableNames[0]);
        }
        return false;
    }

    public AbstractCondition buildCondition(JoinQuery join) {
        TableDescription leftTable = join.findTable(this.tableNames[0]);
        TableDescription rightTable = join.findTable(this.tableNames[1]);
        return new EqualCondition(leftTable.getSimulatedTable(), leftTable.findColumnIndex(this.colName), rightTable.getSimulatedTable(), rightTable.findColumnIndex(this.colName));
    }
}

