/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.xlog;

import com.sap.dbtechtest.util.ObjectServices;
import com.sap.dbtechtest.xlog.AbstractInfo;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.FailureGroup;
import com.sap.dbtechtest.xlog.Info;
import com.sap.dbtechtest.xlog.LogBrace;
import com.sap.dbtechtest.xlog.Parameter;
import com.sap.dbtechtest.xlog.SubFailure;
import com.sap.dbtechtest.xlog.TestDifference;
import com.sap.dbtechtest.xlog.Warning;
import java.util.Stack;

public abstract class LogWriter {
    protected LogBrace current;
    protected Stack nesting = new Stack();
    protected boolean verbose = false;
    protected boolean fluffing = false;
    protected FailureGroup failures;
    protected Stack failureGroups = new Stack();
    private static final String[] javaProperties = new String[]{"java.vm.version", "java.vm.vendor", "os.name"};

    public LogWriter() {
        this(null);
    }

    public LogWriter(String string) {
        this.current = new LogBrace("[outer]");
        this.failures = new FailureGroup("[failures]");
    }

    public boolean setVerboseTo(boolean bl) {
        boolean bl2 = this.verbose;
        this.verbose = bl;
        return bl2;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void addParameter(String string, String string2) {
        Parameter parameter = new Parameter(string, string2);
        this.current.parameters.add(parameter);
    }

    public void addParameter(String string, String string2, String string3) {
        Parameter parameter = new Parameter(string, string2, string3);
        this.current.parameters.add(parameter);
    }

    public void addEnvironmentParameters() {
        this.addParameter("implementation.language", "Java");
        for (int i = 0; i < javaProperties.length; ++i) {
            String string = null;
            try {
                string = System.getProperty(javaProperties[i]);
                if (string == null) {
                    string = "[unknown]";
                }
            }
            catch (SecurityException securityException) {
                string = "[unknown]";
            }
            this.addParameter(javaProperties[i], string);
        }
    }

    public abstract void start();

    public abstract void stop();

    protected abstract void stopFluff();

    public abstract void dumpFailureTree();

    protected abstract void showInfo(AbstractInfo var1);

    public abstract void flush();

    public void push(String string, boolean bl) {
        this.stopFluff();
        this.nesting.push(this.current);
        this.current = new LogBrace(string);
        if (bl) {
            this.start();
        }
        this.pushFailureGroup(string);
    }

    private void pushFailureGroup(String string) {
        FailureGroup failureGroup = new FailureGroup(string);
        this.failures.addGroup(failureGroup);
        this.failureGroups.push(this.failures);
        this.failures = failureGroup;
    }

    public void push(String string) {
        this.push(string, true);
    }

    public void pop() {
        boolean bl = this.hasErrors();
        LogBrace logBrace = this.current;
        this.stop();
        this.current = (LogBrace)this.nesting.pop();
        if (bl && this.current != null) {
            this.addFailure(new SubFailure(logBrace.name));
        }
        this.failures = (FailureGroup)this.failureGroups.pop();
    }

    public void addInfo(String string, String string2) {
        if (this.verbose) {
            this.addInfo(new Info(string, string2));
        }
    }

    public void addInfo(String string) {
        if (this.verbose) {
            this.addInfo(new Info(string));
        }
    }

    public void addInfo(Info info) {
        this.showInfo(info);
    }

    public void addWarning(String string, String string2) {
        this.addWarning(new Warning(string, string2));
    }

    public void addWarning(Warning warning) {
        this.current.warnings.add(warning);
        this.showInfo(warning);
    }

    public void addFailure(Failure failure) {
        this.current.failures.add(failure);
        this.failures.addFailure(failure);
        this.showInfo(failure);
    }

    public boolean addDifference(String string, String string2, Object object, Object object2) {
        boolean bl;
        if (ObjectServices.isEqual(object, object2)) {
            this.addInfo(string, string2 + ": " + ObjectServices.toString(object2));
            bl = true;
        } else {
            this.addFailure(new TestDifference(string, string2, object, object2));
            bl = false;
        }
        return bl;
    }

    public boolean hasErrors() {
        return this.current.failures.size() > 0;
    }
}

