/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.powertoys;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.SQLException;
import java.util.Properties;

public class DBMTest
extends Test {
    private static final String help = "help for Repman";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DBMTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DBMTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        try {
            String string = "Repman";
            Properties properties = new Properties();
            properties.put("host", this.options.getHostname());
            properties.put("dbname", this.getDBName());
            DBM dBM = new DBM(properties);
            this.log.addInfo(string, "session created");
            String string2 = dBM.cmd("user_logon " + this.options.getUser() + "," + this.options.getPassword());
            this.log.addInfo(string, string2);
            string2 = dBM.cmd("db_enum");
            this.log.addInfo(string, string2);
            dBM.release();
        }
        catch (DBMException dBMException) {
            this.log.addFailure(new Failure(dBMException.toString()));
        }
        catch (RTEException rTEException) {
            this.log.addFailure(new Failure(rTEException.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DBMTest dBMTest = new DBMTest(stringArray);
        try {
            dBMTest.runInner();
        }
        finally {
            dBMTest.connection.close();
        }
        if (dBMTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

