/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

public class TypeEnums {
    private static final String[] SQLTypesC = new String[]{"VARCHAR (20) ASCII", "VARCHAR (20) BYTE", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "FIXED (10, 5)", "LONG ASCII", "LONG BYTE"};
    private static final String[] SQLTypesUnicodeC = new String[]{"VARCHAR (20) UNICODE", "LONG UNICODE"};
    public static final String[] JDBCTypesC = new String[]{"Array", "AsciiStream", "BigDecimal", "BinaryStream", "Blob", "Boolean", "Byte", "Bytes", "CharacterStream", "Clob", "Date", "Double", "Float", "Int", "Long", "Object", "Ref", "Short", "String", "Time", "Timestamp", "UnicodeStream"};
    public static final String[] PrimitiveJDBCTypesC = new String[]{"Boolean", "Byte", "Double", "Float", "Int", "Long", "Short"};
    public static final String[] StreamJDBCTypesC = new String[]{"AsciiStream", "BinaryStream", "Blob", "CharacterStream", "Clob", "UnicodeStream"};
    public static final String[] UnsupportedJDBCTypesC = new String[]{"Array", "Ref"};

    public static boolean isPrimitiveType(String string) {
        return TypeEnums.inSet(string, PrimitiveJDBCTypesC);
    }

    public static boolean isStreamType(String string) {
        return TypeEnums.inSet(string, StreamJDBCTypesC);
    }

    public static boolean isNotSupportedType(String string) {
        return TypeEnums.inSet(string, UnsupportedJDBCTypesC);
    }

    private static boolean inSet(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private TypeEnums() {
    }

    public static String[] getSQLTypes(boolean bl) {
        if (!bl) {
            return SQLTypesC;
        }
        String[] stringArray = new String[SQLTypesC.length + SQLTypesUnicodeC.length];
        System.arraycopy(SQLTypesC, 0, stringArray, 0, SQLTypesC.length);
        System.arraycopy(SQLTypesUnicodeC, 0, stringArray, SQLTypesC.length, SQLTypesUnicodeC.length);
        return stringArray;
    }
}

