/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.jdbc.types.InputConversionFailureCase;
import com.sap.dbtechtest.jdbc.types.OutputConversionFailureCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TimestampTest
extends ConversionTest {
    public static java.util.Date now = new java.util.Date();
    private static final String help = "help for TimestampTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "sql column definition", "TIMESTAMP", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("BigDecimal", null), new InputConversionFailureCase("BigDecimal", new BigDecimal(1.0)), new InputConversionFailureCase("Boolean", Boolean.TRUE), new InputConversionFailureCase("Boolean", Boolean.FALSE), new InputConversionFailureCase("Byte", new Byte(1)), (ConversionTestCase)new EqualityTestCase("Bytes", "2000-01-01".getBytes()).knownBug(""), new EqualityTestCase("Date", new Date(100, 0, 1), new Timestamp(100, 0, 1, 0, 0, 0, 0)), new InputConversionFailureCase("Double", new Double(1.1)), new InputConversionFailureCase("Float", new Float(111.111f)), new InputConversionFailureCase("Int", new Integer(3)), new InputConversionFailureCase("Long", new Long(4L)), new EqualityTestCase("Object", new Date(100, 0, 1), new Timestamp(100, 0, 1, 0, 0, 0, 0)), (ConversionTestCase)new EqualityTestCase("Object", "2001-01-01 00:00:00.000", new Timestamp(100, 0, 1, 0, 0, 0, 0)).knownBug(""), new EqualityTestCase("Object", new Time(0, 0, 0), new Timestamp(now.getYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0)), new EqualityTestCase("Object", new Timestamp(100, 0, 1, 0, 0, 0, 0)), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), new InputConversionFailureCase("Short", new Short(5)), (ConversionTestCase)new EqualityTestCase("String", "2001-01-01 00:00:00.000", new Timestamp(100, 0, 1, 0, 0, 0, 0)).knownBug(""), new EqualityTestCase("Time", new Time(0, 0, 0), new Timestamp(now.getYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 0)), (ConversionTestCase)new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 5), new Timestamp(100, 0, 1, 0, 0, 0, 0)).bugFixed("PTS1111443"), (ConversionTestCase)new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 50000)).requireMinKernelVersion("07.03.00.000"), (ConversionTestCase)new EqualityTestCase("Timestamp", new Timestamp(-901, 0, 1, 0, 0, 0, 0)).bugFixed("PTS1111441")};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("BigDecimal", new Timestamp(0L)), new OutputConversionFailureCase("Boolean", new Timestamp(0L)), new OutputConversionFailureCase("Byte", new Timestamp(0L)), new OutputConversionFailureCase("Bytes", new Timestamp(0L)), new EqualityTestCase("Date", new Timestamp(100, 0, 1, 0, 0, 0, 0), new Date(100, 0, 1)), new OutputConversionFailureCase("Double", new Timestamp(0L)), new OutputConversionFailureCase("Float", new Timestamp(0L)), new OutputConversionFailureCase("Int", new Timestamp(0L)), new OutputConversionFailureCase("Long", new Timestamp(0L)), new EqualityTestCase("Object", new Timestamp(100, 0, 1, 0, 0, 0, 0)), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("Short", new Timestamp(0L)), new EqualityTestCase("String", new Timestamp(100, 0, 1, 0, 0, 0, 0), "2000-01-01 00:00:00.000000"), new EqualityTestCase("Time", new Timestamp(100, 0, 1, 0, 0, 0, 0), new Time(0, 0, 0)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 0)), (ConversionTestCase)new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 5), new Timestamp(100, 0, 1, 0, 0, 0, 0)).knownBug("PTSPTS1111443 PTSPTS1111444"), (ConversionTestCase)new EqualityTestCase("Timestamp", new Timestamp(100, 0, 1, 0, 0, 0, 50000)).requireMinKernelVersion("07.03.00.000")};

    public TimestampTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public TimestampTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        TimestampTest timestampTest = new TimestampTest(stringArray);
        try {
            timestampTest.runInner();
        }
        finally {
            timestampTest.connection.close();
        }
        if (timestampTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

