/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.jdbc.types.ConversionTest;
import com.sap.dbtechtest.jdbc.types.ConversionTestCase;
import com.sap.dbtechtest.jdbc.types.EqualityTestCase;
import com.sap.dbtechtest.jdbc.types.InputConversionFailureCase;
import com.sap.dbtechtest.jdbc.types.OutputConversionFailureCase;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.options.StringOption;
import com.sap.dbtechtest.util.testdriver.Test;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TimeTest
extends ConversionTest {
    private static final String help = "help for TimeTest";
    private static final OptionDesc[] optdesc = new OptionDesc[]{new StringOption("sqlcol", "sql column definition", "TIME", null)};
    private final ConversionTestCase[] insertTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setInsertException(JDBCDriverExceptionClass), new EqualityTestCase("BigDecimal", null), new InputConversionFailureCase("BigDecimal", new BigDecimal(1.0)), new InputConversionFailureCase("Boolean", Boolean.TRUE), new InputConversionFailureCase("Boolean", Boolean.FALSE), new InputConversionFailureCase("Byte", new Byte(1)), (ConversionTestCase)new EqualityTestCase("Bytes", "2000-01-01".getBytes()).knownBug(""), new InputConversionFailureCase("Date", new Date(100, 0, 1)), new InputConversionFailureCase("Double", new Double(1.1)), new InputConversionFailureCase("Float", new Float(111.111f)), new InputConversionFailureCase("Int", new Integer(3)), new InputConversionFailureCase("Long", new Long(4L)), new EqualityTestCase("Object", new Time(0, 0, 0)), new EqualityTestCase("Object", "00:00:00", new Time(0, 0, 0)), new EqualityTestCase("Ref", null).setInsertException(JDBCDriverExceptionClass), new InputConversionFailureCase("Short", new Short(5)), new EqualityTestCase("String", "00:00:00", new Time(0, 0, 0)), new EqualityTestCase("Time", new Time(0, 0, 0)), new EqualityTestCase("Timestamp", new Timestamp(100, 0, 0, 0, 0, 0, 0), new Time(0, 0, 0))};
    private final ConversionTestCase[] fetchTests = new ConversionTestCase[]{new EqualityTestCase("Array", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("BigDecimal", new Time(0, 0, 0)), new OutputConversionFailureCase("Boolean", new Time(0, 0, 0)), new OutputConversionFailureCase("Byte", new Time(0, 0, 0)), new OutputConversionFailureCase("Bytes", new Time(0, 0, 0)), new OutputConversionFailureCase("Date", new Time(0, 0, 0)), new OutputConversionFailureCase("Double", new Time(0, 0, 0)), new OutputConversionFailureCase("Float", new Time(0, 0, 0)), new OutputConversionFailureCase("Int", new Time(0, 0, 0)), new OutputConversionFailureCase("Long", new Time(0, 0, 0)), new EqualityTestCase("Object", new Time(0, 0, 0)), new EqualityTestCase("Ref", null).setFetchException(JDBCDriverExceptionClass), new OutputConversionFailureCase("Short", new Time(0, 0, 0)), new EqualityTestCase("String", new Time(0, 0, 0), "00:00:00"), new EqualityTestCase("Time", new Time(0, 0, 0)), new EqualityTestCase("Timestamp", new Time(0, 0, 0), new Timestamp(70, 0, 1, 0, 0, 0, 0))};

    public TimeTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public TimeTest(Test test) throws SQLException {
        super(test);
        this.options.addExtraOptions(optdesc);
    }

    protected ConversionTestCase[] getInputTestCases() {
        return this.insertTests;
    }

    protected ConversionTestCase[] getFetchTestCases() {
        return this.fetchTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        TimeTest timeTest = new TimeTest(stringArray);
        try {
            timeTest.runInner();
        }
        finally {
            timeTest.connection.close();
        }
        if (timeTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

