/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

public class SQLType {
    private String coldef;
    private String defaultJDBCType;

    private SQLType(String string, String string2) {
        this.coldef = string;
        this.defaultJDBCType = string2;
    }

    private SQLType(String string, int n, String string2) {
        this(string + " (" + n + ")", string2);
    }

    private SQLType(String string, int n, String string2, String string3) {
        this(string + " (" + n + ") " + string2, string3);
    }

    private SQLType(String string, int n, int n2, String string2) {
        this(string + " (" + n + ", " + n2 + ")", string2);
    }

    public String getColdef() {
        return this.coldef;
    }

    public String getJDBCType() {
        return this.defaultJDBCType;
    }

    public static SQLType CHAR() {
        return new SQLType("CHAR", "String");
    }

    public static SQLType CHAR(int n) {
        return new SQLType("CHAR", n, "String");
    }

    public static SQLType UNICODE() {
        return new SQLType("CHAR UNICODE", "String");
    }

    public static SQLType UNICODE(int n) {
        return new SQLType("CHAR", n, "UNICODE", "String");
    }

    public static SQLType BYTE() {
        return new SQLType("CHAR", "Bytes");
    }

    public static SQLType BYTE(int n) {
        return new SQLType("CHAR", n, "BYTE", "Bytes");
    }

    public static SQLType FIXED() {
        return new SQLType("FIXED", "Long");
    }

    public static SQLType FIXED(int n) {
        return new SQLType("FIXED", n, "Long");
    }

    public static SQLType FIXED(int n, int n2) {
        return new SQLType("FIXED", n, n2, "BigDecimal");
    }

    public static SQLType FLOAT() {
        return new SQLType("FLOAT", "Double");
    }

    public static SQLType FLOAT(int n) {
        return new SQLType("FLOAT", n, "Double");
    }

    public static SQLType DATE() {
        return new SQLType("DATE", "Date");
    }

    public static SQLType Time() {
        return new SQLType("TIME", "Time");
    }

    public static SQLType Timestamp() {
        return new SQLType("TIMESTAMP", "Timestamp");
    }

    public static SQLType Boolean() {
        return new SQLType("BOOLEAN", "Boolean");
    }

    public static SQLType LONG() {
        return new SQLType("LONG", "CharacterStream");
    }

    public static SQLType LONGUNICODE() {
        return new SQLType("LONG UNICODE", "CharacterStream");
    }

    public static SQLType LONGBINARY() {
        return new SQLType("LONG BYTE", "BinaryStream");
    }
}

