/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NumberToStringTest
extends Test {
    private static final String help = "Try some string representations for numbers.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    static String[] FLOAT_CHECK_ARRAY = new String[]{"1", "1.1", "1.11", "1.111", "1.1111", "1.11111", "1.111111", "1.1111111", "1.11111111", "1.111111111", "1.1111111111", "1.11111111111", "1.111111111111", "1.1111111111111", "1.11111111111111", "1.111111111111111", "1.1111111111111111", "1.11111111111111111", "1.111111111111111111", "1.1111111111111111111", "1.11111111111111111111", "1.111111111111111111111", "1.1111111111111111111111", "1.11111111111111111111111", "1.111111111111111111111111", "1.1111111111111111111111111", "1.11111111111111111111111111", "1.111111111111111111111111111", "1.1111111111111111111111111111", "1.11111111111111111111111111111", "1.111111111111111111111111111111", "1.1111111111111111111111111111111", "1.11111111111111111111111111111111", "1.111111111111111111111111111111111", "1.1111111111111111111111111111111111", "1.11111111111111111111111111111111111", "1.111111111111111111111111111111111111", "1.1111111111111111111111111111111111111", "0.11111111111111111111111111111111111111E-62", "0.11111111111111111111111111111111111111E-61", "0.11111111111111111111111111111111111111E-60", "0.11111111111111111111111111111111111111E-59", "0.11111111111111111111111111111111111111E-58", "0.11111111111111111111111111111111111111E-57", "0.11111111111111111111111111111111111111E-56", "0.11111111111111111111111111111111111111E-55", "0.11111111111111111111111111111111111111E-54", "0.11111111111111111111111111111111111111E-53", "0.11111111111111111111111111111111111111E-52", "0.11111111111111111111111111111111111111E-51", "0.11111111111111111111111111111111111111E-50", "0.11111111111111111111111111111111111111E-49", "0.11111111111111111111111111111111111111E-48", "0.11111111111111111111111111111111111111E-47", "0.11111111111111111111111111111111111111E-46", "0.11111111111111111111111111111111111111E-45", "0.11111111111111111111111111111111111111E-44", "0.11111111111111111111111111111111111111E-43", "0.11111111111111111111111111111111111111E-42", "0.11111111111111111111111111111111111111E-41", "0.11111111111111111111111111111111111111E-40", "0.11111111111111111111111111111111111111E-39", "0.11111111111111111111111111111111111111E-38", "0.11111111111111111111111111111111111111E-37", "0.11111111111111111111111111111111111111E-36", "0.11111111111111111111111111111111111111E-35", "0.11111111111111111111111111111111111111E-34", "0.11111111111111111111111111111111111111E-33", "0.11111111111111111111111111111111111111E-32", "0.11111111111111111111111111111111111111E-31", "0.11111111111111111111111111111111111111E-30", "0.11111111111111111111111111111111111111E-29", "0.11111111111111111111111111111111111111E-28", "0.11111111111111111111111111111111111111E-27", "0.11111111111111111111111111111111111111E-26", "0.11111111111111111111111111111111111111E-25", "0.11111111111111111111111111111111111111E-24", "0.11111111111111111111111111111111111111E-23", "0.11111111111111111111111111111111111111E-22", "0.11111111111111111111111111111111111111E-21", "0.11111111111111111111111111111111111111E-20", "0.11111111111111111111111111111111111111E-19", "0.11111111111111111111111111111111111111E-18", "0.11111111111111111111111111111111111111E-17", "0.11111111111111111111111111111111111111E-16", "0.11111111111111111111111111111111111111E-15", "0.11111111111111111111111111111111111111E-14", "0.11111111111111111111111111111111111111E-13", "0.11111111111111111111111111111111111111E-12", "0.11111111111111111111111111111111111111E-11", "0.11111111111111111111111111111111111111E-10", "0.11111111111111111111111111111111111111E-9", "0.11111111111111111111111111111111111111E-8", "0.11111111111111111111111111111111111111E-7", "0.11111111111111111111111111111111111111E-6", "0.11111111111111111111111111111111111111E-5", "0.11111111111111111111111111111111111111E-4", "0.00011111111111111111111111111111111111111", "0.0011111111111111111111111111111111111111", "0.011111111111111111111111111111111111111", "0.11111111111111111111111111111111111111", "1.1111111111111111111111111111111111111", "11.111111111111111111111111111111111111", "111.11111111111111111111111111111111111", "1111.1111111111111111111111111111111111", "11111.111111111111111111111111111111111", "111111.11111111111111111111111111111111", "1111111.1111111111111111111111111111111", "0.11111111111111111111111111111111111111E8", "0.11111111111111111111111111111111111111E9", "0.11111111111111111111111111111111111111E10", "0.11111111111111111111111111111111111111E11", "0.11111111111111111111111111111111111111E12", "0.11111111111111111111111111111111111111E13", "0.11111111111111111111111111111111111111E14", "0.11111111111111111111111111111111111111E15", "0.11111111111111111111111111111111111111E16", "0.11111111111111111111111111111111111111E17", "0.11111111111111111111111111111111111111E18", "0.11111111111111111111111111111111111111E19", "0.11111111111111111111111111111111111111E20", "0.11111111111111111111111111111111111111E21", "0.11111111111111111111111111111111111111E22", "0.11111111111111111111111111111111111111E23", "0.11111111111111111111111111111111111111E24", "0.11111111111111111111111111111111111111E25", "0.11111111111111111111111111111111111111E26", "0.11111111111111111111111111111111111111E27", "0.11111111111111111111111111111111111111E28", "0.11111111111111111111111111111111111111E29", "0.11111111111111111111111111111111111111E30", "0.11111111111111111111111111111111111111E31", "0.11111111111111111111111111111111111111E32", "0.11111111111111111111111111111111111111E33", "0.11111111111111111111111111111111111111E34", "0.11111111111111111111111111111111111111E35", "0.11111111111111111111111111111111111111E36", "0.11111111111111111111111111111111111111E37", "0.11111111111111111111111111111111111111E38", "0.11111111111111111111111111111111111111E39", "0.11111111111111111111111111111111111111E40", "0.11111111111111111111111111111111111111E41", "0.11111111111111111111111111111111111111E42", "0.11111111111111111111111111111111111111E43", "0.11111111111111111111111111111111111111E44", "0.11111111111111111111111111111111111111E45", "0.11111111111111111111111111111111111111E46", "0.11111111111111111111111111111111111111E47", "0.11111111111111111111111111111111111111E48", "0.11111111111111111111111111111111111111E49", "0.11111111111111111111111111111111111111E50", "0.11111111111111111111111111111111111111E51", "0.11111111111111111111111111111111111111E52", "0.11111111111111111111111111111111111111E53", "0.11111111111111111111111111111111111111E54", "0.11111111111111111111111111111111111111E55", "0.11111111111111111111111111111111111111E56", "0.11111111111111111111111111111111111111E57", "0.11111111111111111111111111111111111111E58", "0.11111111111111111111111111111111111111E59", "0.11111111111111111111111111111111111111E60", "0.11111111111111111111111111111111111111E61", "0.11111111111111111111111111111111111111E62", "0.11111111111111111111111111111111111111E63"};
    private String tableName = "";

    public NumberToStringTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public NumberToStringTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        this.tableName = this.getUnicodeIdentifier("TEST_FIXEDSTRING");
        this.testRunFloat();
        this.testRunFixed();
    }

    public void testRunFixed() throws SQLException {
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(" + "F FIXED(8,3)" + ")");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0.001)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0.011)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0.111)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0.010)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0.100)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (0)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (1.01)");
        this.stmt.execute("INSERT INTO " + this.tableName + " VALUES (11111.1)");
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName + "");
        resultSet.setFetchSize(1);
        String[] stringArray = new String[]{"0.001", "0.011", "0.111", "0.010", "0.100", "0", "1.010", "11111.100"};
        for (int i = 0; i < stringArray.length; ++i) {
            resultSet.next();
            String string = resultSet.getString(1);
            if (string.equals(stringArray[i])) continue;
            this.log.addFailure(new Failure("Value expected was" + stringArray[i] + " Value retrieved was " + string));
        }
    }

    public void testRunFloat() throws SQLException {
        int n;
        this.dropTable(this.tableName);
        this.stmt.execute("CREATE TABLE " + this.tableName + "(" + "F FLOAT(38)" + ")");
        PreparedStatement preparedStatement = this.prepare("INSERT INTO " + this.tableName + " VALUES (?)");
        String string = "1.";
        for (n = 0; n < 38; ++n) {
            BigDecimal bigDecimal = new BigDecimal(string);
            preparedStatement.setBigDecimal(1, bigDecimal);
            preparedStatement.execute();
            string = string + "1";
        }
        for (n = -63; n < 63; ++n) {
            this.stmt.execute("INSERT INTO " + this.tableName + " VALUES(" + string + "E" + n + ")");
        }
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + this.tableName);
        resultSet.setFetchSize(1);
        for (int i = 0; i < FLOAT_CHECK_ARRAY.length; ++i) {
            resultSet.next();
            String string2 = resultSet.getString(1);
            if (string2.equals(FLOAT_CHECK_ARRAY[i])) continue;
            this.log.addFailure(new Failure("Value expected was" + FLOAT_CHECK_ARRAY[i] + " Value retrieved was " + string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        NumberToStringTest numberToStringTest = new NumberToStringTest(stringArray);
        try {
            numberToStringTest.runInner();
        }
        finally {
            numberToStringTest.connection.close();
        }
        if (numberToStringTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

