/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class LongStreamTest
extends Test {
    private static final String help = "Test for stream handling.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LongStreamTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongStreamTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("TEST_LONGSTREAM");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (A LONG BYTE)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?)");
        preparedStatement.setBinaryStream(1, (InputStream)new NastyStream(), 27);
        try {
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            preparedStatement.close();
            return;
        }
        this.log.addFailure(new Failure("No exception although stream was not good."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongStreamTest longStreamTest = new LongStreamTest(stringArray);
        try {
            longStreamTest.runInner();
        }
        finally {
            longStreamTest.connection.close();
        }
        if (longStreamTest.log.hasErrors()) {
            System.exit(5);
        }
    }

    static class NastyStream
    extends InputStream {
        NastyStream() {
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("I am nasty.");
        }

        public int read() throws IOException {
            throw new IOException("I am nasty.");
        }
    }
}

