/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AddBatchUnicode
extends Test {
    private static final String help = "help for AddBatchUnicode";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public AddBatchUnicode(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public AddBatchUnicode(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "AddBatchUnicode";
        String string2 = "AddBatchUnicode";
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a varchar(100), b int)");
        String string3 = this.getUnicodeIdentifier("this is unicode:");
        Statement statement = this.connection.createStatement();
        for (int i = 1; i <= 200; ++i) {
            if (i % 20 == 0) {
                statement.addBatch("insert into " + string2 + " values ('" + string3 + "', " + i + ")");
                continue;
            }
            statement.addBatch("insert into " + string2 + " values ('ascii value " + i + "', " + i + ")");
        }
        int[] nArray = statement.executeBatch();
        this.log.addInfo(string, "no of result counts: " + nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.log.addDifference(string, "resultCount: ", new Integer(1), new Integer(nArray[i]));
        }
        ResultSet resultSet = this.select("select a from " + string2 + " order by b");
        for (int i = 1; i <= 200; ++i) {
            if (!resultSet.next()) {
                this.log.addDifference(string, "next ()", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            String string4 = resultSet.getString(1);
            if (i % 20 == 0) {
                this.log.addDifference(string, "fetch", string3, string4);
                continue;
            }
            this.log.addDifference(string, "fetch", "ascii value " + i, string4);
        }
        string = "empty batch";
        nArray = statement.executeBatch();
        this.log.addDifference(string, "no of resultCounts", new Integer(0), new Integer(nArray.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        AddBatchUnicode addBatchUnicode = new AddBatchUnicode(stringArray);
        try {
            addBatchUnicode.runInner();
        }
        finally {
            addBatchUnicode.connection.close();
        }
        if (addBatchUnicode.log.hasErrors()) {
            System.exit(5);
        }
    }
}

