/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SelectForUpdate2
extends Test {
    private static final String help = "help for SelectForUpdate2";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SelectForUpdate2(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SelectForUpdate2(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "SelectForUpdate2";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (ID   INTEGER   NOT NULL, TS   INTEGER   NOT NULL)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (1, 1)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (2, 2)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (3, 3)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (4, 4)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (5, 5)");
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        resultSet.setFetchSize(1);
        int n = 1;
        while (resultSet.next()) {
            this.log.addDifference(string, "checking non mass fetch ROW " + n + " COLUMN 1", new Integer(n), resultSet.getObject(1));
            this.log.addDifference(string, "checking non mass fetch ROW " + n + " COLUMN 2", new Integer(n++), resultSet.getObject(2));
        }
        Statement statement = this.connection.createStatement(1004, 1008);
        statement.setCursorName("mycursor");
        ResultSet resultSet2 = statement.executeQuery("SELECT ID, TS FROM " + string2);
        resultSet2.setFetchSize(1);
        while (resultSet2.next()) {
            int n2 = resultSet2.getInt("TS");
            if (n2 % 2 == 0) {
                resultSet2.updateInt(2, n2 + 2);
                resultSet2.updateRow();
                continue;
            }
            resultSet2.deleteRow();
        }
        statement.close();
        this.connection.commit();
        ResultSet resultSet3 = this.stmt.executeQuery("SELECT * FROM " + string2);
        resultSet3.setFetchSize(1);
        resultSet3.next();
        this.log.addDifference(string, "checking pdated values", new Integer(2), resultSet3.getObject(1));
        this.log.addDifference(string, "checking pdated values", new Integer(4), resultSet3.getObject(2));
        resultSet3.next();
        this.log.addDifference(string, "checking pdated values", new Integer(4), resultSet3.getObject(1));
        this.log.addDifference(string, "checking pdated values", new Integer(6), resultSet3.getObject(2));
        this.log.addDifference(string, "fetch next", Boolean.FALSE, new Boolean(resultSet3.next()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SelectForUpdate2 selectForUpdate2 = new SelectForUpdate2(stringArray);
        try {
            selectForUpdate2.runInner();
        }
        finally {
            selectForUpdate2.connection.close();
        }
        if (selectForUpdate2.log.hasErrors()) {
            System.exit(5);
        }
    }
}

