/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.rest;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseMetaDataGetColumn
extends Test {
    private static final String help = "help for DatabaseMetaDataGetColumn";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private String tableName = "";

    public DatabaseMetaDataGetColumn(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DatabaseMetaDataGetColumn(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "DatabaseMetaDataGetColumn";
        this.tableName = this.getUnicodeIdentifier("DBMDGetColumn");
        this.dropTable(this.tableName);
        this.connection.commit();
        if (this.isSQLModeOracle()) {
            if (this.environment.hasFeature("UnicodeDB")) {
                this.checkOracleModeUnicode(string);
            } else {
                this.checkOracleMode(string);
            }
        } else if (this.environment.hasFeature("UnicodeDB")) {
            this.checkInternalModeUnicode(string);
        } else {
            this.checkInternalMode(string);
        }
        this.checkEscapeSyntax();
    }

    public void checkEscapeSyntax() throws SQLException {
        this.dropTable("CHECKESCAPEESC_1");
        this.dropTable("CHECKESCAPEESC11");
        this.stmt.execute("CREATE TABLE CHECKESCAPEESC_1 (A INTEGER)");
        this.stmt.execute("CREATE TABLE CHECKESCAPEESC11 (A INTEGER)");
        ResultSet resultSet = this.connection.getMetaData().getColumns(null, null, "CHECKESCAPEESC_1", null);
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        if (n != 2) {
            this.log.addFailure(new Failure("First call should return two rows."));
        }
        resultSet = this.connection.getMetaData().getColumns(null, null, "CHECKESCAPEESC\\_1", null);
        n = 0;
        while (resultSet.next()) {
            ++n;
        }
        if (n != 1) {
            this.log.addFailure(new Failure("Second call should return one row."));
        }
    }

    void checkInternalMode(String string) throws SQLException {
        short[] sArray;
        String string2 = "";
        int[] nArray = new int[]{1, 1, 1, 1, 10, 5, 5, 5, 1, 10, 8, 26, 0, 0};
        short[] sArray2 = new short[]{1, -2, 12, -3, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4};
        short[] sArray3 = new short[]{-7, -4, -3, -2, -1, 1, 3, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93};
        if (this.checkVersion("7.6.0")) {
            sArray3 = sArray = new short[]{-4, -3, -2, -1, -1, 1, 1, 3, 3, 3, 4, 5, 6, 7, 8, 12, 12, 16, 91, 92, 93};
        }
        sArray = sArray3;
        short[] sArray4 = sArray2;
        this.stmt.execute("CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", null, this.tableName.toUpperCase(), "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns" + resultSet.getString("COLUMN_NAME"), new Short(sArray4[n]), new Short(resultSet.getShort("DATA_TYPE")));
            this.log.addDifference(string, "Check COLUMN_SIZE for column " + n + " Column_Type " + resultSet.getString("TYPE_NAME") + " " + resultSet.getString("COLUMN_SIZE"), new Integer(nArray[n]), new Integer(resultSet.getInt("COLUMN_SIZE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
        ResultSet resultSet2 = this.connection.getMetaData().getCatalogs();
        while (resultSet2.next()) {
            this.log.addDifference(string, "Check Catalog Name", "", resultSet2.getString(1));
        }
    }

    void checkInternalModeUnicode(String string) throws SQLException {
        short[] sArray;
        String string2 = "";
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 10, 5, 5, 5, 1, 10, 8, 26, 0, 0, 0};
        short[] sArray2 = new short[]{1, -2, 1, 12, -3, 12, 4, 5, 6, 3, -7, 91, 92, 93, -1, -4, -1};
        short[] sArray3 = new short[]{-7, -4, -3, -2, -1, -1, 1, 1, 3, 3, 4, 5, 6, 7, 8, 12, 12, 91, 92, 93};
        if (this.checkVersion("7.6.0")) {
            sArray3 = sArray = new short[]{-4, -3, -2, -1, -1, -1, 1, 1, 1, 3, 3, 3, 4, 5, 6, 7, 8, 12, 12, 12, 16, 91, 92, 93};
        }
        sArray = sArray3;
        short[] sArray4 = sArray2;
        this.stmt.execute("CREATE TABLE " + this.tableName + " (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHARUNICODE Varchar (1) UNICODE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_FIXED        Fixed (5)," + "    C_BOOLEAN      Boolean," + "    C_DATE         Date," + "    C_TIME         Time," + "    C_TIMESTAMP    Timestamp," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", null, this.tableName.toUpperCase(), "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns for column " + n + " Column_Type " + resultSet.getString("TYPE_NAME") + " " + resultSet.getString("COLUMN_NAME"), new Short(sArray4[n]), new Short(resultSet.getShort("DATA_TYPE")));
            this.log.addDifference(string, "Check COLUMN_SIZE for column " + n + " Column_Type " + resultSet.getString("TYPE_NAME") + " " + resultSet.getString("COLUMN_SIZE"), new Integer(nArray[n]), new Integer(resultSet.getInt("COLUMN_SIZE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
        ResultSet resultSet2 = this.connection.getMetaData().getCatalogs();
        while (resultSet2.next()) {
            this.log.addDifference(string, "Check Catalog Name", "", resultSet2.getString(1));
        }
    }

    void checkOracleMode(String string) throws SQLException {
        Object object;
        int[] nArray = new int[]{1, 1, 1, 1, 10, 5, 5, 5, 1, 10, 8, 10, 0, 0};
        short[] sArray = new short[]{1, -2, 12, -3, 2, 2, 6, 91, -1, -4};
        Object object2 = new short[]{-4, -3, -2, -1, 1, 3, 4, 5, 6, 7, 8, 12, 91};
        if (this.checkVersion("7.6.0")) {
            object = new short[]{-4, -3, -2, -1, -1, -1, 1, 1, 1, 3, 3, 3, 4, 5, 6, 7, 8, 12, 12, 12, 16, 91, 92, 93};
            object2 = object;
        }
        this.stmt.execute("CREATE TABLE " + this.tableName + "   (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_DATE         Date," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE" + ")");
        this.connection.commit();
        object = this.connection.getMetaData().getColumns("", null, this.tableName.toUpperCase(), "%");
        int n = 0;
        while (object.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns for column " + n + " Column_Type " + object.getString("TYPE_NAME") + " " + object.getString("COLUMN_NAME"), new Short(sArray[n]), new Short(object.getShort("DATA_TYPE")));
            this.log.addDifference(string, "Check COLUMN_SIZE for column " + n + " Column_Type " + object.getString("TYPE_NAME") + " " + object.getString("COLUMN_SIZE"), new Integer(nArray[n]), new Integer(object.getInt("COLUMN_SIZE")));
            ++n;
        }
        object = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (object.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + object.getString("TYPE_NAME"), new Short(object2[n]), new Short(object.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
    }

    void checkOracleModeUnicode(String string) throws SQLException {
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 10, 5, 5, 5, 1, 10, 8, 10, 0, 0, 0};
        short[] sArray = new short[]{1, -2, 1, 12, -3, 12, 2, 2, 6, 91, -1, -4, -1};
        short[] sArray2 = new short[]{-4, -3, -2, -1, -1, 1, 1, 3, 4, 5, 6, 7, 8, 12, 12, 91};
        this.stmt.execute("CREATE TABLE " + this.tableName + "   (C_CHARASCII    Char (1) ASCII," + "    C_CHARBYTE     Char (1) BYTE," + "    C_CHARUNICODE  Char (1) UNICODE," + "    C_VARCHARASCII Varchar (1) ASCII," + "    C_VARCHARBYTE  Varchar (1) BYTE," + "    C_VARCHAUNICODE Varchar (1) UNICODE," + "    C_INT          Integer," + "    C_SMALINT      Smallint," + "    C_FLOAT        Float (5)," + "    C_DATE         Date," + "    C_LONGASCII    Long ASCII," + "    C_LONGBYTE     Long BYTE," + "    C_LONGUNICODE  Long UNICODE" + ")");
        this.connection.commit();
        ResultSet resultSet = this.connection.getMetaData().getColumns("", null, this.tableName.toUpperCase(), "%");
        int n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getColumns for column " + n + " Column_Type " + resultSet.getString("TYPE_NAME") + " " + resultSet.getString("COLUMN_NAME"), new Short(sArray[n]), new Short(resultSet.getShort("DATA_TYPE")));
            this.log.addDifference(string, "Check COLUMN_SIZE for column " + n + " Column_Type " + resultSet.getString("TYPE_NAME") + " " + resultSet.getString("COLUMN_SIZE"), new Integer(nArray[n]), new Integer(resultSet.getInt("COLUMN_SIZE")));
            ++n;
        }
        resultSet = this.connection.getMetaData().getTypeInfo();
        n = 0;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check SQLTypes Mapping getTypeInfo" + resultSet.getString("TYPE_NAME"), new Short(sArray2[n]), new Short(resultSet.getShort("DATA_TYPE")));
            ++n;
        }
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DatabaseMetaDataGetColumn databaseMetaDataGetColumn = new DatabaseMetaDataGetColumn(stringArray);
        try {
            databaseMetaDataGetColumn.runInner();
        }
        finally {
            databaseMetaDataGetColumn.connection.close();
        }
        if (databaseMetaDataGetColumn.log.hasErrors()) {
            System.exit(5);
        }
    }
}

