/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class RowNotFound
extends Test {
    private static final String help = "help for RowNotFound";
    private static int maxConn = 10;
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public RowNotFound(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public RowNotFound(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "RowNotFound";
        String string2 = this.getUnicodeIdentifier(string);
        for (int i = 1; i <= maxConn; ++i) {
            SelectLoop selectLoop = new SelectLoop(this, string2);
            selectLoop.setName("Loop Thread " + i);
            selectLoop.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        RowNotFound rowNotFound = new RowNotFound(stringArray);
        try {
            rowNotFound.runInner();
        }
        finally {
            rowNotFound.connection.close();
        }
        if (rowNotFound.log.hasErrors()) {
            System.exit(5);
        }
    }

    public final class SelectLoop
    extends Thread {
        static final String selcmd = "SELECT \"PID\",\"VAL\" FROM \"UME_STRINGS\" WHERE \"NAMESP\" = ? AND \"NAMESPH\" = ? AND \"ATTR\" = ? AND \"ATTRH\" = ? AND (\"VAL\" = ? AND \"VALH\" = ? OR \"VAL\" = ? AND \"VALH\" = ? OR \"VAL\" = ? AND \"VALH\" = ?)";
        static final String explainselcmd = "EXPLAIN SELECT \"PID\",\"VAL\" FROM \"UME_STRINGS\" WHERE \"NAMESP\" = 'com.sap.security.core.usermanagement.relation' AND \"NAMESPH\" = 5087255000015074520 AND \"ATTR\" = 'PRINCIPAL_RELATION_MEMBER_ATTRIBUTE' AND \"ATTRH\" = 8646158209357641878 AND (\"VAL\" = 'GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE' AND \"VALH\" = 1064977531701498038 OR \"VAL\" = 'GRUP.PRIVATE_DATASOURCE.un:Administrators' AND \"VALH\" = 8872837317890783764 OR \"VAL\" = 'GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS' AND \"VALH\" = 8963440317020645765)";
        Connection conn;
        PreparedStatement ps;
        Statement st;
        String tabname;
        int loopCnt;

        public SelectLoop(Test test, String string) throws SQLException {
            this.conn = test.connect();
            this.ps = this.conn.prepareStatement(selcmd);
            this.st = this.conn.createStatement();
            this.tabname = this.tabname;
        }

        private synchronized void printExplain() throws SQLException {
            this.loopCnt = 0;
            System.out.println(this.getName() + " EXPALIN:");
            ResultSet resultSet = this.st.executeQuery(explainselcmd);
            if (!resultSet.next()) {
                System.out.println("row not found");
            } else {
                int n;
                int n2;
                String string;
                int n3;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuffer stringBuffer = new StringBuffer(50);
                stringBuffer.append("| ");
                for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                    string = resultSetMetaData.getColumnName(n3);
                    n2 = resultSetMetaData.getPrecision(n3);
                    if (string.length() > n2) {
                        stringBuffer.append(string.substring(0, n2));
                    } else {
                        stringBuffer.append(string);
                        for (n = 0; n < n2 - string.length(); ++n) {
                            stringBuffer.append(" ");
                        }
                    }
                    stringBuffer.append(" | ");
                }
                System.out.println(stringBuffer.toString());
                for (n3 = 1; n3 < stringBuffer.length(); ++n3) {
                    System.out.print("-");
                }
                System.out.println("");
                do {
                    stringBuffer = new StringBuffer(stringBuffer.capacity());
                    stringBuffer.append("| ");
                    for (n3 = 1; n3 <= resultSetMetaData.getColumnCount(); ++n3) {
                        string = resultSet.getString(n3);
                        n2 = resultSetMetaData.getPrecision(n3);
                        if (string.length() > n2) {
                            stringBuffer.append(string.substring(0, n2));
                        } else {
                            stringBuffer.append(string);
                            for (n = 0; n < n2 - string.length(); ++n) {
                                stringBuffer.append(" ");
                            }
                        }
                        stringBuffer.append(" | ");
                    }
                    System.out.println(stringBuffer.toString());
                } while (resultSet.next());
            }
        }

        public void run() {
            try {
                while (true) {
                    if (this.loopCnt >= 100) {
                        this.printExplain();
                    }
                    this.ps.clearBatch();
                    this.ps.clearParameters();
                    this.ps.setObject(1, (Object)"com.sap.security.core.usermanagement.relation", 12);
                    this.ps.setLong(2, 5087255000015074520L);
                    this.ps.setObject(3, (Object)"PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", 12);
                    this.ps.setLong(4, 8646158209357641878L);
                    this.ps.setObject(5, (Object)"GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE", 12);
                    this.ps.setLong(6, 1064977531701498038L);
                    this.ps.setObject(7, (Object)"GRUP.PRIVATE_DATASOURCE.un:Administrators", 12);
                    this.ps.setLong(8, -8872837317890783764L);
                    this.ps.setObject(9, (Object)"GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS", 12);
                    this.ps.setLong(10, 8963440317020645765L);
                    ResultSet resultSet = this.ps.executeQuery();
                    if (!resultSet.next()) {
                        throw new Exception(this.getName() + " ERROR !!!!!!! Row Not Found !!!!!! ERROR");
                    }
                    ++this.loopCnt;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

