/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final boolean DEBUG = false;
    private static XSParticleDecl fErrorContent = null;

    XSDComplexTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSComplexTypeDecl traverseLocal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, false, schemaDoc);
        String complexTypeName = this.genAnonTypeName(complexTypeNode);
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    XSComplexTypeDecl traverseGlobal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, true, schemaDoc);
        String complexTypeName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        grammar.addGlobalTypeDecl(type);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element complexTypeDecl, String complexTypeName, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Boolean abstractAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt blockAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        XInt finalAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        XSComplexTypeDecl complexType = new XSComplexTypeDecl();
        complexType.fName = complexTypeName;
        complexType.fTargetNamespace = schemaDoc.fTargetNamespace;
        complexType.fBlock = blockAtt == null ? schemaDoc.fBlockDefault : blockAtt.shortValue();
        short s = complexType.fFinal = finalAtt == null ? schemaDoc.fFinalDefault : finalAtt.shortValue();
        if (abstractAtt != null && abstractAtt.booleanValue()) {
            complexType.setIsAbstractType();
        }
        Element child = null;
        try {
            child = DOMUtil.getFirstChildElement(complexTypeDecl);
            if (child != null) {
                if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                    child = DOMUtil.getNextSiblingElement(child);
                }
                if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.reportGenericSchemaError("ComplexType " + complexTypeName + " has more than one annotation.");
                }
            }
            if (child == null) {
                complexType.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, complexType, mixedAtt, false, schemaDoc, grammar);
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(child, complexType, schemaDoc, grammar);
                if (DOMUtil.getNextSiblingElement(child) != null) {
                    String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(child));
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{complexType.fName, siblingName});
                }
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(child, complexType, mixedAtt, schemaDoc, grammar);
                if (DOMUtil.getNextSiblingElement(child) != null) {
                    String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(child));
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{complexType.fName, siblingName});
                }
            } else {
                complexType.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, complexType, mixedAtt, false, schemaDoc, grammar);
            }
        }
        catch (ComplexTypeRecoverableError e) {
            this.handleComplexTypeError(e.getMessage(), e.errorSubstText, complexType);
        }
        return complexType;
    }

    private void traverseSimpleContent(Element simpleContentElement, XSComplexTypeDecl typeInfo, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String typeName = typeInfo.fName;
        Object[] attrValues = this.fAttrChecker.checkAttributes(simpleContentElement, false, schemaDoc);
        typeInfo.fContentType = 1;
        typeInfo.fParticle = null;
        Element simpleContent = DOMUtil.getFirstChildElement(simpleContentElement);
        if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(simpleContent, attrValues, false, schemaDoc);
            simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (simpleContent == null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "complexContent must have either restriction or extension as child");
            throw new ComplexTypeRecoverableError();
        }
        String simpleContentName = DOMUtil.getLocalName(simpleContent);
        if (simpleContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            typeInfo.fDerivedBy = (short)2;
        } else if (simpleContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            typeInfo.fDerivedBy = 1;
        } else {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "Child of simpleContent must be restriction or extension");
            throw new ComplexTypeRecoverableError();
        }
        if (DOMUtil.getNextSiblingElement(simpleContent) != null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "Invalid child of simpleContent");
            throw new ComplexTypeRecoverableError();
        }
        attrValues = this.fAttrChecker.checkAttributes(simpleContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base attribute must be specified for the restriction or extension");
            throw new ComplexTypeRecoverableError();
        }
        XSTypeDecl type = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        typeInfo.fBaseType = type;
        DatatypeValidator baseValidator = null;
        XSComplexTypeDecl baseComplexType = null;
        int baseFinalSet = 0;
        if (type instanceof XSComplexTypeDecl) {
            baseComplexType = (XSComplexTypeDecl)type;
            if (baseComplexType.fContentType != 1) {
                this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base type must be complex");
                throw new ComplexTypeRecoverableError();
            }
            baseFinalSet = baseComplexType.fFinal;
            baseValidator = baseComplexType.fDatatypeValidator;
        } else {
            baseValidator = (DatatypeValidator)type;
            if (typeInfo.fDerivedBy == 2) {
                this.reportGenericSchemaError("ComplexType " + typeName + ": " + "ct-props-correct.2:  The base is a simple type.   It cannot be used in a derivation by restriction");
                throw new ComplexTypeRecoverableError();
            }
            baseFinalSet = baseValidator.getFinalSet();
        }
        if ((baseFinalSet & typeInfo.fDerivedBy) != 0) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base type has a final value that prohibits this derivation");
            throw new ComplexTypeRecoverableError();
        }
        if ((simpleContent = DOMUtil.getFirstChildElement(simpleContent)) != null) {
            if (DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(simpleContent, null, false, schemaDoc);
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.reportGenericSchemaError("ComplexType " + typeName + " simpleContent has more than one annotation.");
            }
        }
        if (typeInfo.fDerivedBy == 2) {
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                DatatypeValidator dv = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(simpleContent, schemaDoc, grammar);
                if (dv == null) {
                    throw new ComplexTypeRecoverableError();
                }
                if (!XSConstraints.checkSimpleDerivationOk(dv, baseValidator, baseValidator.getFinalSet())) {
                    this.reportGenericSchemaError("ComplexType " + typeName + ": " + "derivation-ok-restriction.5.1.1:  The content type is not a valid restriction of the content type of the base");
                }
                baseValidator = dv;
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            Hashtable fFacetData = null;
            Element attrNode = null;
            if (simpleContent != null) {
                XSDAbstractTraverser.fFacetInfo fi = this.traverseFacets(simpleContent, null, typeName, baseValidator, schemaDoc, grammar);
                fFacetData = fi.facetdata;
                attrNode = fi.nodeAfterFacets;
            }
            typeInfo.fDatatypeValidator = this.createRestrictedValidator(baseValidator, fFacetData, this.fErrorReporter);
            if (typeInfo.fDatatypeValidator == null) {
                this.reportGenericSchemaError("Internal error - could not create a new validator");
                throw new ComplexTypeRecoverableError();
            }
            if (attrNode != null) {
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
                }
            }
            this.mergeAttributes(baseComplexType.fAttrGrp, typeInfo.fAttrGrp, typeName, false);
            typeInfo.fAttrGrp.removeProhibitedAttrs();
            String error = typeInfo.fAttrGrp.validRestrictionOf(baseComplexType.fAttrGrp);
            if (error != null) {
                this.reportGenericSchemaError("ComplexType " + typeName + ": " + error);
                throw new ComplexTypeRecoverableError();
            }
        } else {
            typeInfo.fDatatypeValidator = baseValidator;
            if (simpleContent != null) {
                Element attrNode = simpleContent;
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
                }
                typeInfo.fAttrGrp.removeProhibitedAttrs();
                if (baseComplexType != null) {
                    this.mergeAttributes(baseComplexType.fAttrGrp, typeInfo.fAttrGrp, typeName, true);
                }
            }
        }
    }

    private void traverseComplexContent(Element complexContentElement, XSComplexTypeDecl typeInfo, boolean mixedOnType, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String typeName = typeInfo.fName;
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexContentElement, false, schemaDoc);
        boolean mixedContent = mixedOnType;
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        if (mixedAtt != null) {
            mixedContent = mixedAtt;
        }
        typeInfo.fDatatypeValidator = null;
        Element complexContent = DOMUtil.getFirstChildElement(complexContentElement);
        if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(complexContent, attrValues, false, schemaDoc);
            complexContent = DOMUtil.getNextSiblingElement(complexContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (complexContent == null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "complexContent must have either restriction or extension as child");
            throw new ComplexTypeRecoverableError();
        }
        String complexContentName = DOMUtil.getLocalName(complexContent);
        if (complexContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            typeInfo.fDerivedBy = (short)2;
        } else if (complexContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            typeInfo.fDerivedBy = 1;
        } else {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "Child of complexContent must be restriction or extension");
            throw new ComplexTypeRecoverableError();
        }
        if (DOMUtil.getNextSiblingElement(complexContent) != null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "Invalid child of complexContent");
            throw new ComplexTypeRecoverableError();
        }
        attrValues = this.fAttrChecker.checkAttributes(complexContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base attribute must be specified for the restriction or extension");
            throw new ComplexTypeRecoverableError();
        }
        XSTypeDecl type = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        if (!(type instanceof XSComplexTypeDecl)) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base type must be complex");
            throw new ComplexTypeRecoverableError();
        }
        XSComplexTypeDecl baseType = (XSComplexTypeDecl)type;
        typeInfo.fBaseType = baseType;
        if ((baseType.fFinal & typeInfo.fDerivedBy) != 0) {
            this.reportGenericSchemaError("ComplexType " + typeName + ": " + "The base type has a final value that prohibits this derivation");
            throw new ComplexTypeRecoverableError();
        }
        if ((complexContent = DOMUtil.getFirstChildElement(complexContent)) != null) {
            if (DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(complexContent, null, false, schemaDoc);
                complexContent = DOMUtil.getNextSiblingElement(complexContent);
            }
            if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.reportGenericSchemaError("ComplexType " + typeName + " complexContent has more than one annotation.");
            }
        }
        this.processComplexContent(complexContent, typeInfo, mixedContent, true, schemaDoc, grammar);
        XSParticleDecl baseContent = baseType.fParticle;
        if (typeInfo.fDerivedBy == 2) {
            if (typeInfo.fParticle == null && baseContent != null && !baseContent.emptiable()) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction", null);
            }
            if (typeInfo.fParticle != null && baseContent == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction", null);
            }
            this.mergeAttributes(baseType.fAttrGrp, typeInfo.fAttrGrp, typeName, false);
            String error = typeInfo.fAttrGrp.validRestrictionOf(baseType.fAttrGrp);
            if (error != null) {
                this.reportGenericSchemaError("ComplexType " + typeName + ": " + error);
                throw new ComplexTypeRecoverableError();
            }
            typeInfo.fAttrGrp.removeProhibitedAttrs();
        } else {
            if (baseType.fContentType != 0 && (baseType.fContentType == 3 && mixedContent || baseType.fContentType == 2 && !mixedContent)) {
                this.reportGenericSchemaError("cos-ct-extends.1.4.2.2.2.1: The content type of the base type " + baseTypeName + " and derived type " + typeName + " must both be mixed or element-only");
                throw new ComplexTypeRecoverableError();
            }
            if (typeInfo.fParticle == null) {
                typeInfo.fParticle = baseContent;
            } else if (baseContent != null) {
                if (typeInfo.fParticle.fType == 5 || baseType.fParticle.fType == 5) {
                    this.reportGenericSchemaError("cos-all-limited.1.2:  An \"all\" model group that is part of a complex type definition must constitute the entire {content type} of the definition");
                    throw new ComplexTypeRecoverableError();
                }
                XSParticleDecl temp = new XSParticleDecl();
                temp.fType = (short)4;
                temp.fValue = baseContent;
                temp.fOtherValue = typeInfo.fParticle;
                typeInfo.fParticle = temp;
            }
            typeInfo.fContentType = mixedContent ? (short)2 : (typeInfo.fParticle == null ? (short)0 : (short)3);
            typeInfo.fAttrGrp.removeProhibitedAttrs();
            this.mergeAttributes(baseType.fAttrGrp, typeInfo.fAttrGrp, typeName, true);
        }
    }

    private void mergeAttributes(XSAttributeGroupDecl fromAttrGrp, XSAttributeGroupDecl toAttrGrp, String typeName, boolean extension) throws ComplexTypeRecoverableError {
        XSAttributeUse[] attrUseS = fromAttrGrp.getAttributeUses();
        Object duplicateAttrUse = null;
        int i = 0;
        while (i < attrUseS.length) {
            XSAttributeUse existingAttrUse = toAttrGrp.getAttributeUse(attrUseS[i].fAttrDecl.fTargetNamespace, attrUseS[i].fAttrDecl.fName);
            if (existingAttrUse == null) {
                String idName = toAttrGrp.addAttributeUse(attrUseS[i]);
                if (idName != null) {
                    this.reportGenericSchemaError("Two distinct members of the {attribute uses} '" + idName + "' and '" + attrUseS[i].fAttrDecl.fName + "' have {attribute declaration}s both of whose {type definition}s are or are derived from ID");
                }
            } else if (extension) {
                this.reportGenericSchemaError("ComplexType " + typeName + ": " + "Duplicate attribute use " + existingAttrUse.fAttrDecl.fName);
                throw new ComplexTypeRecoverableError();
            }
            ++i;
        }
        if (extension) {
            if (toAttrGrp.fAttributeWC == null) {
                toAttrGrp.fAttributeWC = fromAttrGrp.fAttributeWC;
            } else if (fromAttrGrp.fAttributeWC != null) {
                toAttrGrp.fAttributeWC = toAttrGrp.fAttributeWC.performUnionWith(fromAttrGrp.fAttributeWC, toAttrGrp.fAttributeWC.fProcessContents);
                if (toAttrGrp.fAttributeWC == null) {
                    this.reportGenericSchemaError("intersection of wildcards is not expressible");
                }
            }
        }
    }

    private void processComplexContent(Element complexContentChild, XSComplexTypeDecl typeInfo, boolean isMixed, boolean isDerivation, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        Element attrNode = null;
        XSParticleDecl particle = null;
        String typeName = typeInfo.fName;
        if (complexContentChild != null) {
            String childName = DOMUtil.getLocalName(complexContentChild);
            if (childName.equals(SchemaSymbols.ELT_GROUP)) {
                particle = this.fSchemaHandler.fGroupTraverser.traverseLocal(complexContentChild, schemaDoc, grammar);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(complexContentChild, schemaDoc, grammar, 0);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(complexContentChild, schemaDoc, grammar, 0);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(complexContentChild, schemaDoc, grammar, 8);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else {
                attrNode = complexContentChild;
            }
        }
        typeInfo.fParticle = particle;
        typeInfo.fContentType = isMixed ? (short)2 : (typeInfo.fParticle == null ? (short)0 : (short)3);
        if (attrNode != null) {
            if (!this.isAttrOrAttrGroup(attrNode)) {
                throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
            }
            Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
            if (node != null) {
                throw new ComplexTypeRecoverableError("src-ct", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
            }
            if (!isDerivation) {
                typeInfo.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element e) {
        String elementName = DOMUtil.getLocalName(e);
        return elementName.equals(SchemaSymbols.ELT_ATTRIBUTE) || elementName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || elementName.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseSimpleContentDecl(Element simpleContentDecl, XSComplexTypeDecl typeInfo) {
    }

    private void traverseComplexContentDecl(Element complexContentDecl, XSComplexTypeDecl typeInfo, boolean mixedOnComplexTypeDecl) {
    }

    private String genAnonTypeName(Element complexTypeDecl) {
        Element node = DOMUtil.getParent(complexTypeDecl);
        String typeName = "#AnonType_";
        while (node != null && node != DOMUtil.getRoot(DOMUtil.getDocument(node))) {
            typeName = typeName + node.getAttribute(SchemaSymbols.ATT_NAME);
            node = DOMUtil.getParent(node);
        }
        return typeName;
    }

    private void handleComplexTypeError(String messageId, Object[] args, XSComplexTypeDecl typeInfo) {
        if (messageId != null) {
            this.reportSchemaError(messageId, args);
        }
        typeInfo.fContentType = (short)2;
        typeInfo.fParticle = XSDComplexTypeTraverser.getErrorContent();
    }

    private static XSParticleDecl getErrorContent() {
        if (fErrorContent == null) {
            fErrorContent = new XSParticleDecl();
            XSDComplexTypeTraverser.fErrorContent.fType = (short)4;
            XSParticleDecl particle = new XSParticleDecl();
            XSWildcardDecl wildcard = new XSWildcardDecl();
            wildcard.fProcessContents = (short)2;
            particle.fType = (short)2;
            particle.fValue = wildcard;
            particle.fMinOccurs = 0;
            particle.fMaxOccurs = -1;
            XSDComplexTypeTraverser.fErrorContent.fValue = particle;
            XSDComplexTypeTraverser.fErrorContent.fOtherValue = null;
        }
        return fErrorContent;
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String msgKey) {
            super(msgKey);
        }

        ComplexTypeRecoverableError(String msgKey, Object[] args) {
            super(msgKey);
            this.errorSubstText = args;
        }
    }
}

