/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarResolver;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.xni.QName;

public class SubstitutionGroupHandler {
    XSGrammarResolver fGrammarResolver;

    public SubstitutionGroupHandler(XSGrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void reset() {
    }

    public void addSubstitutionGroup(XSElementDecl element) {
    }

    public XSElementDecl[] getSubstitutionGroup(String elementUri, String elementName) {
        return null;
    }

    public XSElementDecl getMatchingElemDecl(QName element, XSElementDecl exemplar) {
        if (element.localpart == exemplar.fName && element.uri == exemplar.fTargetNamespace) {
            return exemplar;
        }
        if ((exemplar.fBlock & 0x20) != 0) {
            return null;
        }
        SchemaGrammar sGrammar = this.fGrammarResolver.getGrammar(element.uri);
        if (sGrammar == null) {
            return null;
        }
        XSElementDecl eDecl = sGrammar.getGlobalElementDecl(element.localpart);
        if (eDecl == null) {
            return null;
        }
        if (this.substitutionGroupOK(eDecl, exemplar, exemplar.fBlock)) {
            return eDecl;
        }
        return null;
    }

    public boolean substitutionGroupOK(XSElementDecl element, XSElementDecl exemplar, short blockingConstraint) {
        if ((blockingConstraint & 0x20) != 0) {
            return false;
        }
        int devMethod = 0;
        short blockConstraint = blockingConstraint;
        XSTypeDecl type = element.fType;
        devMethod = type.getXSType() == 1 ? (int)((XSComplexTypeDecl)type).fDerivedBy : 2;
        type = exemplar.fType;
        if (type.getXSType() == 1) {
            blockConstraint = (short)(blockConstraint | ((XSComplexTypeDecl)type).fBlock);
        }
        XSElementDecl subGroup = element.fSubGroup;
        while (subGroup != null && subGroup != exemplar) {
            type = subGroup.fType;
            if (type.getXSType() == 1) {
                devMethod = (short)(devMethod | ((XSComplexTypeDecl)type).fDerivedBy);
                blockConstraint = (short)(blockConstraint | ((XSComplexTypeDecl)type).fBlock);
            } else {
                devMethod = (short)(devMethod | 2);
            }
            subGroup = subGroup.fSubGroup;
        }
        if (subGroup == null) {
            return false;
        }
        return (devMethod & blockConstraint) == 0;
    }
}

