/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class IDREFDatatypeValidator
extends StringDatatypeValidator {
    private static Object fNullValue = new Object();
    public static final int IDREF_VALIDATE = 0;
    public static final int IDREF_CHECKID = 1;

    public IDREFDatatypeValidator() {
        this(null, null, false, null);
    }

    public IDREFDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
        if (derivedByList) {
            return;
        }
        if (base instanceof IDREFDatatypeValidator) {
            this.setTokenType(((IDREFDatatypeValidator)base).fTokenType);
        } else {
            this.setTokenType("IDREF(Name)");
        }
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        Object retVal = super.validate(content, state);
        if (state != null) {
            state.addIdRef(content);
            if (!state.isIdDeclared(content)) {
                InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
            }
        }
        return retVal;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }
}

