/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;

public class StringDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private short fWhiteSpace = 0;
    private int fFacetsDefined = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;

    public StringDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public StringDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.setBasetype(base);
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("length")) {
                    ++this.fFacetsDefined;
                    String lengthValue = (String)facets.get(key);
                    try {
                        this.fLength = Integer.parseInt(lengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("minlength")) {
                    this.fFacetsDefined += 2;
                    String minLengthValue = (String)facets.get(key);
                    try {
                        this.fMinLength = Integer.parseInt(minLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("minLength value '" + minLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("maxlength")) {
                    this.fFacetsDefined += 4;
                    String maxLengthValue = (String)facets.get(key);
                    try {
                        this.fMaxLength = Integer.parseInt(maxLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + maxLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)facets.get(key);
                    continue;
                }
                if (key.equals("whitespace")) {
                    String whiteSpaceChoice = (String)facets.get(key);
                    this.fFacetsDefined += 32;
                    if (whiteSpaceChoice.equals("preserve")) {
                        this.fWhiteSpace = 1;
                        continue;
                    }
                    if (whiteSpaceChoice.equals("replace")) {
                        this.fWhiteSpace = (short)2;
                        continue;
                    }
                    if (!whiteSpaceChoice.equals("collapse")) continue;
                    this.fWhiteSpace = (short)3;
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + key);
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be less than the value of maxLength = '" + this.fMaxLength + "'.");
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x200) != 0;
            boolean bl = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
        }
    }

    public void validate(String content, Object state) throws InvalidDatatypeValueException {
        this.checkContent(content, state);
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Hashtable getFacets() {
        return null;
    }

    private void checkContent(String content, Object state) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            this.fBaseValidator.validate(content, state);
        }
        if ((this.fFacetsDefined & 4) != 0 && content.length() > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + content.length() + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && content.length() < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + content.length() + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && content.length() != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + content.length() + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(content)) {
            throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + this.fEnumeration);
        }
    }

    public int compare(String content, String facetValue) {
        Locale loc = Locale.getDefault();
        Collator collator = Collator.getInstance(loc);
        return collator.compare(content, facetValue);
    }

    public Object clone() throws CloneNotSupportedException {
        StringDatatypeValidator newObj = null;
        try {
            newObj = new StringDatatypeValidator();
            newObj.fLocale = this.fLocale;
            newObj.fBaseValidator = this.fBaseValidator;
            newObj.fLength = this.fLength;
            newObj.fMaxLength = this.fMaxLength;
            newObj.fMinLength = this.fMinLength;
            newObj.fPattern = this.fPattern;
            newObj.fEnumeration = this.fEnumeration;
            newObj.fFacetsDefined = this.fFacetsDefined;
            newObj.isMaxExclusiveDefined = this.isMaxExclusiveDefined;
            newObj.isMaxInclusiveDefined = this.isMaxInclusiveDefined;
            newObj.isMinExclusiveDefined = this.isMinExclusiveDefined;
            newObj.isMinInclusiveDefined = this.isMinInclusiveDefined;
        }
        catch (InvalidDatatypeFacetException ex) {
            ex.printStackTrace();
        }
        return newObj;
    }

    private void setBasetype(DatatypeValidator base) {
        this.fBaseValidator = base;
    }
}

