/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;

public final class DeferredAttrNSImpl
extends AttrNSImpl
implements DeferredNode {
    static final long serialVersionUID = 6074924934945957154L;
    protected transient int fNodeIndex;

    DeferredAttrNSImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        String prefix;
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument();
        this.name = ownerDocument.getNodeName(this.fNodeIndex);
        int index = this.name.indexOf(58);
        if (index < 0) {
            prefix = null;
            this.localName = this.name;
        } else {
            prefix = this.name.substring(0, index);
            this.localName = this.name.substring(index + 1);
        }
        this.isSpecified(ownerDocument.getNodeExtra(this.fNodeIndex) == 1);
        this.namespaceURI = ownerDocument.getNodeURI(this.fNodeIndex);
        if (this.namespaceURI != null && this.namespaceURI.length() == 0) {
            this.namespaceURI = null;
        }
        if (this.namespaceURI == null) {
            if (prefix != null) {
                if (prefix.equals("xmlns")) {
                    this.namespaceURI = "http://www.w3.org/2000/xmlns/";
                }
            } else if (this.name.equals("xmlns")) {
                this.namespaceURI = "http://www.w3.org/2000/xmlns/";
            }
        }
    }

    protected void synchronizeChildren() {
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument();
        ownerDocument.synchronizeChildren(this, this.fNodeIndex);
    }
}

